/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.tenant;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.webapp.security.tenant.OperateTenant;
import io.camunda.operate.webapp.security.tenant.TenantAwareAuthentication;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class TenantService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantService.class);
    @Autowired
    private OperateProperties operateProperties;

    public AuthenticatedTenants getAuthenticatedTenants() {
        if (!this.securityContextPresent()) {
            return AuthenticatedTenants.allTenants();
        }
        if (!this.isMultiTenancyEnabled()) {
            return AuthenticatedTenants.assignedTenants(List.of("<default>"));
        }
        TenantAwareAuthentication authentication = this.getCurrentTenantAwareAuthentication();
        List<String> tenants = this.getTenantsFromAuthentication(authentication);
        if (tenants != null && !tenants.isEmpty()) {
            return AuthenticatedTenants.assignedTenants(tenants);
        }
        return AuthenticatedTenants.noTenantsAssigned();
    }

    private TenantAwareAuthentication getCurrentTenantAwareAuthentication() {
        TenantAwareAuthentication currentAuthentication;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof TenantAwareAuthentication) {
            TenantAwareAuthentication tenantAwareAuthentication;
            currentAuthentication = tenantAwareAuthentication = (TenantAwareAuthentication)authentication;
        } else {
            currentAuthentication = null;
            String message = String.format("Multi Tenancy is not supported with current authentication type %s", authentication.getClass());
            LOGGER.error(message, (Throwable)new OperateRuntimeException());
        }
        return currentAuthentication;
    }

    private List<String> getTenantsFromAuthentication(TenantAwareAuthentication authentication) {
        List<OperateTenant> tenants;
        ArrayList<String> authenticatedTenants = new ArrayList<String>();
        if (authentication != null && (tenants = authentication.getTenants()) != null && !tenants.isEmpty()) {
            tenants.stream().map(OperateTenant::getTenantId).collect(Collectors.toCollection(() -> authenticatedTenants));
        }
        return authenticatedTenants;
    }

    private boolean isMultiTenancyEnabled() {
        return this.operateProperties.getMultiTenancy().isEnabled();
    }

    private boolean securityContextPresent() {
        return SecurityContextHolder.getContext().getAuthentication() != null;
    }

    public static class AuthenticatedTenants {
        private final TenantAccessType tenantAccessType;
        private final List<String> ids;

        AuthenticatedTenants(TenantAccessType tenantAccessType, List<String> ids) {
            this.tenantAccessType = tenantAccessType;
            this.ids = ids;
        }

        public static AuthenticatedTenants allTenants() {
            return new AuthenticatedTenants(TenantAccessType.TENANT_ACCESS_ALL, null);
        }

        public static AuthenticatedTenants noTenantsAssigned() {
            return new AuthenticatedTenants(TenantAccessType.TENANT_ACCESS_NONE, null);
        }

        public static AuthenticatedTenants assignedTenants(List<String> tenants) {
            return new AuthenticatedTenants(TenantAccessType.TENANT_ACCESS_ASSIGNED, tenants);
        }

        public TenantAccessType getTenantAccessType() {
            return this.tenantAccessType;
        }

        public List<String> getTenantIds() {
            return this.ids;
        }
    }

    public static enum TenantAccessType {
        TENANT_ACCESS_ALL,
        TENANT_ACCESS_ASSIGNED,
        TENANT_ACCESS_NONE;

    }
}

