/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.sso;

import com.auth0.IdentityVerificationException;
import io.camunda.operate.webapp.security.sso.Auth0Service;
import io.camunda.operate.webapp.security.sso.Auth0ServiceException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Profile(value={"sso-auth"})
public class SSOController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    @Autowired
    private Auth0Service auth0Service;
    private SecurityContextRepository securityContextRepository = new HttpSessionSecurityContextRepository();

    @RequestMapping(value={"/api/login"}, method={RequestMethod.GET, RequestMethod.POST})
    public String login(HttpServletRequest req, HttpServletResponse res) {
        String authorizeUrl = this.auth0Service.getAuthorizeUrl(req, res);
        this.logger.debug("Redirect Login to {}", (Object)authorizeUrl);
        return "redirect:" + authorizeUrl;
    }

    @GetMapping(value={"/sso-callback"})
    public void loggedInCallback(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.logger.debug("Called back by auth0 with {} {} and SessionId: {}", new Object[]{req.getRequestURI(), req.getQueryString(), req.getSession().getId()});
        try {
            Authentication authentication = this.auth0Service.authenticate(req, res);
            SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
            context.setAuthentication(authentication);
            this.securityContextHolderStrategy.setContext(context);
            this.securityContextRepository.saveContext(context, req, res);
            this.sessionExpiresWhenAuthenticationExpires(req);
            this.redirectToPage(req, res);
        }
        catch (InsufficientAuthenticationException iae) {
            this.clearContextAndRedirectToNoPermission(req, res, iae);
        }
        catch (Auth0ServiceException ase) {
            this.handleAuth0Exception(ase, req, res);
        }
    }

    private void handleAuth0Exception(Auth0ServiceException ase, HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.logger.error("Error in authentication callback: ", (Throwable)ase);
        Throwable cause = ase.getCause();
        if (cause != null) {
            if (cause instanceof InsufficientAuthenticationException) {
                this.logoutAndRedirectToNoPermissionPage(req, res);
            } else if (cause instanceof IdentityVerificationException || cause instanceof AuthenticationException) {
                this.clearContextAndRedirectToNoPermission(req, res, cause);
            } else {
                this.logout(req, res);
            }
        } else {
            this.logout(req, res);
        }
    }

    private void redirectToPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Object originalRequestUrl = req.getSession().getAttribute("requestedUrl");
        if (originalRequestUrl != null) {
            res.sendRedirect(req.getContextPath() + String.valueOf(originalRequestUrl));
        } else {
            res.sendRedirect(req.getContextPath() + "/operate");
        }
    }

    @RequestMapping(value={"/noPermission"})
    @ResponseBody
    public String noPermissions() {
        return "No permission for Operate - Please check your operate configuration or cloud configuration.";
    }

    @RequestMapping(value={"/api/logout"})
    public void logout(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.logger.debug("logout user");
        this.cleanup(req);
        this.logoutFromAuth0(res, this.auth0Service.getRedirectURI(req, "/operate"));
    }

    protected void clearContextAndRedirectToNoPermission(HttpServletRequest req, HttpServletResponse res, Throwable t) throws IOException {
        this.logger.error("Error in authentication callback: ", t);
        this.cleanup(req);
        res.sendRedirect(this.auth0Service.getRedirectURI(req, "/noPermission"));
    }

    protected void logoutAndRedirectToNoPermissionPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.logger.warn("User is authenticated but there are no permissions.");
        this.cleanup(req);
        this.logoutFromAuth0(res, this.auth0Service.getRedirectURI(req, "/noPermission"));
    }

    protected void cleanup(HttpServletRequest req) {
        req.getSession().invalidate();
        SecurityContext context = this.securityContextHolderStrategy.getContext();
        if (context != null) {
            context.setAuthentication(null);
            this.securityContextHolderStrategy.clearContext();
        }
    }

    protected void logoutFromAuth0(HttpServletResponse res, String returnTo) throws IOException {
        res.sendRedirect(this.auth0Service.getLogoutUrlFor(returnTo));
    }

    private void sessionExpiresWhenAuthenticationExpires(HttpServletRequest req) {
        req.getSession().setMaxInactiveInterval(-1);
    }
}

