/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.oauth2;

import io.camunda.operate.webapp.security.oauth2.JwtAuthenticationTokenValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!identity-auth"})
public class Jwt2AuthenticationTokenConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private final JwtAuthenticationConverter delegate = new JwtAuthenticationConverter();
    @Autowired
    private JwtAuthenticationTokenValidator validator;

    public AbstractAuthenticationToken convert(Jwt jwt) {
        JwtAuthenticationToken token = (JwtAuthenticationToken)this.delegate.convert(jwt);
        if (this.validator.isValid(token)) {
            return token;
        }
        throw new InvalidBearerTokenException("JWT payload validation failed");
    }
}

