/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.oauth2;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.webapp.security.oauth2.JwtAuthenticationTokenValidator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!identity-auth"})
public class CCSaaSJwtAuthenticationTokenValidator
implements JwtAuthenticationTokenValidator {
    public static final String AUDIENCE = "aud";
    public static final String CLUSTER_ID_CLAIM = "https://camunda.com/clusterId";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public boolean isValid(JwtAuthenticationToken token) {
        Map payload = token.getTokenAttributes();
        return this.isValid(payload);
    }

    private boolean isValid(Map<String, Object> payload) {
        try {
            return this.getClusterId(payload).equals(this.getClusterIdFromConfiguration()) && this.getAudience(payload).equals(this.getAudienceFromConfiguration());
        }
        catch (Exception e) {
            this.logger.error(String.format("Validation of JWT payload failed due to %s. Request is not authenticated.", e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private String getClusterId(Map<String, Object> payload) {
        Object clusterIdObject = payload.get(CLUSTER_ID_CLAIM);
        if (clusterIdObject == null) {
            throw new OperateRuntimeException("Couldn't get clusterId from JWT payload. Maybe wrong clusterId configuration?");
        }
        if (clusterIdObject instanceof String) {
            return (String)clusterIdObject;
        }
        if (clusterIdObject instanceof List) {
            return (String)CollectionUtil.firstOrDefault((List)((List)CollectionUtil.getOrDefaultFromMap(payload, (Object)AUDIENCE, Collections.emptyList())), null);
        }
        throw new OperateRuntimeException("Couldn't get clusterId from JWT payload as String or list of Strings. Maybe wrong clusterId configuration?");
    }

    private String getAudience(Map<String, Object> payload) {
        Object audienceObject = payload.get(AUDIENCE);
        if (audienceObject == null) {
            throw new OperateRuntimeException("Couldn't get audience from JWT payload.");
        }
        if (audienceObject instanceof String) {
            return (String)audienceObject;
        }
        if (audienceObject instanceof List) {
            return (String)((List)audienceObject).get(0);
        }
        throw new OperateRuntimeException("Couldn't get audience from JWT payload as String or array of Strings.");
    }

    private String getClusterIdFromConfiguration() {
        String clusterId = this.operateProperties.getCloud().getClusterId();
        if (ConversionUtils.stringIsEmpty((String)clusterId)) {
            this.logger.warn("ClusterId should come from 'CAMUNDA_OPERATE_CLOUD_CLUSTERID' try 'CAMUNDA_OPERATE_CLIENT_CLUSTERID'");
            clusterId = this.operateProperties.getClient().getClusterId();
        }
        if (ConversionUtils.stringIsEmpty((String)clusterId)) {
            throw new OperateRuntimeException("No configuration found in 'CAMUNDA_OPERATE_CLOUD_CLUSTERID' or 'CAMUNDA_OPERATE_CLIENT_CLUSTERID'");
        }
        return clusterId;
    }

    private String getAudienceFromConfiguration() {
        String audience = this.operateProperties.getClient().getAudience();
        if (ConversionUtils.stringIsEmpty((String)audience)) {
            throw new OperateRuntimeException("No configuration found in 'CAMUNDA_OPERATE_CLIENT_AUDIENCE'");
        }
        return audience;
    }
}

