/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.identity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.authentication.exception.TokenDecodeException;
import io.camunda.identity.sdk.impl.rest.exception.RestException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.SpringContextHolder;
import io.camunda.operate.webapp.security.Permission;
import io.camunda.operate.webapp.security.identity.IdentityAuthorization;
import io.camunda.operate.webapp.security.identity.IdentityRetryService;
import io.camunda.operate.webapp.security.identity.PermissionConverter;
import io.camunda.operate.webapp.security.tenant.OperateTenant;
import io.camunda.operate.webapp.security.tenant.TenantAwareAuthentication;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class IdentityAuthentication
extends AbstractAuthenticationToken
implements Serializable,
TenantAwareAuthentication {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityAuthentication.class);
    private Tokens tokens;
    private String id;
    private String name;
    private List<String> permissions;
    @JsonIgnore
    private List<IdentityAuthorization> authorizations;
    private String subject;
    private Date expires;
    private Date refreshTokenExpiresAt;
    private List<OperateTenant> tenants;

    public IdentityAuthentication() {
        super(null);
    }

    public String getCredentials() {
        return this.tokens.getAccessToken();
    }

    public Object getPrincipal() {
        return this.subject;
    }

    public Tokens getTokens() {
        return this.tokens;
    }

    private boolean hasExpired() {
        return this.expires == null || this.expires.before(new Date());
    }

    private boolean hasRefreshTokenExpired() {
        try {
            LOGGER.info("Refresh token will expire at {}", (Object)this.refreshTokenExpiresAt);
            return this.refreshTokenExpiresAt == null || this.refreshTokenExpiresAt.before(new Date());
        }
        catch (TokenDecodeException e) {
            LOGGER.info("Refresh token is not a JWT and expire date can not be determined. Error message: {}", (Object)e.getMessage());
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isAuthenticated() {
        if (this.hasExpired()) {
            LOGGER.info("Access token is expired");
            if (this.hasRefreshTokenExpired()) {
                LOGGER.info("No refresh token available. Authentication is invalid.");
                this.setAuthenticated(false);
                this.getIdentity().authentication().revokeToken(this.tokens.getRefreshToken());
                return false;
            }
            LOGGER.info("Get a new access token by using refresh token");
            try {
                this.renewAccessToken();
            }
            catch (Exception e) {
                LOGGER.error("Renewing access token failed with exception", (Throwable)e);
                this.setAuthenticated(false);
            }
        }
        return super.isAuthenticated();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityAuthentication that = (IdentityAuthentication)o;
        return Objects.equals(this.tokens, that.tokens) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.permissions, that.permissions) && Objects.equals(this.authorizations, that.authorizations) && Objects.equals(this.subject, that.subject) && Objects.equals(this.expires, that.expires) && Objects.equals(this.refreshTokenExpiresAt, that.refreshTokenExpiresAt) && Objects.equals(this.tenants, that.tenants);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokens, this.id, this.name, this.permissions, this.authorizations, this.subject, this.expires, this.refreshTokenExpiresAt, this.tenants);
    }

    public String getId() {
        return this.id;
    }

    public List<Permission> getPermissions() {
        PermissionConverter permissionConverter = this.getPermissionConverter();
        return this.permissions.stream().map(permissionConverter::convert).toList();
    }

    public IdentityAuthentication setPermissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IdentityAuthorization> getAuthorizations() {
        if (this.authorizations == null) {
            IdentityAuthentication identityAuthentication = this;
            synchronized (identityAuthentication) {
                if (this.authorizations == null) {
                    this.retrieveResourcePermissions();
                }
            }
        }
        return this.authorizations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperateTenant> getTenants() {
        if (this.tenants == null) {
            IdentityAuthentication identityAuthentication = this;
            synchronized (identityAuthentication) {
                if (this.tenants == null) {
                    this.retrieveTenants();
                }
            }
        }
        return this.tenants;
    }

    private void retrieveResourcePermissions() {
        if (this.getOperateProperties().getIdentity().isResourcePermissionsEnabled()) {
            try {
                this.authorizations = IdentityAuthorization.createFrom(this.getIdentity().authorizations().forToken(this.tokens.getAccessToken()));
            }
            catch (RestException ex) {
                LOGGER.warn("Unable to retrieve resource base permissions from Identity. Error: " + ex.getMessage(), (Throwable)ex);
                this.authorizations = new ArrayList<IdentityAuthorization>();
            }
        }
    }

    private void retrieveTenants() {
        if (this.getOperateProperties().getMultiTenancy().isEnabled()) {
            try {
                String accessToken = this.tokens.getAccessToken();
                List identityTenants = this.getIdentity().tenants().forToken(accessToken);
                this.tenants = identityTenants != null ? identityTenants.stream().map(t -> new OperateTenant(t.getTenantId(), t.getName())).toList() : new ArrayList<OperateTenant>();
            }
            catch (RestException ex) {
                LOGGER.warn("Unable to retrieve tenants from Identity. Error: " + ex.getMessage(), (Throwable)ex);
                this.tenants = new ArrayList<OperateTenant>();
            }
        }
    }

    public void authenticate(Tokens tokens) {
        if (tokens != null) {
            this.tokens = tokens;
        }
        AccessToken accessToken = this.getIdentity().authentication().verifyToken(this.tokens.getAccessToken());
        UserDetails userDetails = accessToken.getUserDetails();
        this.id = userDetails.getId();
        this.retrieveName(userDetails);
        this.permissions = accessToken.getPermissions();
        this.retrieveResourcePermissions();
        if (!this.getPermissions().contains((Object)Permission.READ)) {
            throw new InsufficientAuthenticationException("No read permissions");
        }
        this.retrieveTenants();
        this.subject = accessToken.getToken().getSubject();
        this.expires = accessToken.getToken().getExpiresAt();
        LOGGER.info("Access token will expire at {}", (Object)this.expires);
        if (!this.isPolling()) {
            try {
                this.refreshTokenExpiresAt = this.getIdentity().authentication().decodeJWT(this.tokens.getRefreshToken()).getExpiresAt();
            }
            catch (TokenDecodeException e) {
                LOGGER.error("Unable to decode refresh token {} with exception: {}", (Object)this.tokens.getRefreshToken(), (Object)e.getMessage());
            }
        }
        this.setAuthenticated(!this.hasExpired());
    }

    private boolean isPolling() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            return Boolean.TRUE.equals(Boolean.parseBoolean(requestAttributes.getRequest().getHeader("x-is-polling")));
        }
        return false;
    }

    private void retrieveName(UserDetails userDetails) {
        String username = userDetails.getUsername().orElse("");
        this.name = userDetails.getName().orElse(username);
    }

    private void renewAccessToken() throws Exception {
        this.authenticate(this.renewTokens(this.tokens.getRefreshToken()));
    }

    private Tokens renewTokens(String refreshToken) throws Exception {
        return (Tokens)this.getIdentityRetryService().requestWithRetry(() -> this.getIdentity().authentication().renewToken(refreshToken), "IdentityAuthentication#renewTokens");
    }

    public IdentityAuthentication setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    private Identity getIdentity() {
        return (Identity)SpringContextHolder.getBean(Identity.class);
    }

    private OperateProperties getOperateProperties() {
        return (OperateProperties)SpringContextHolder.getBean(OperateProperties.class);
    }

    private IdentityRetryService getIdentityRetryService() {
        return (IdentityRetryService)SpringContextHolder.getBean(IdentityRetryService.class);
    }

    private PermissionConverter getPermissionConverter() {
        return (PermissionConverter)SpringContextHolder.getBean(PermissionConverter.class);
    }
}

