/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security;

import io.camunda.operate.OperateProfileService;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.property.WebSecurityProperties;
import io.camunda.operate.webapp.security.CsrfRequireMatcher;
import io.camunda.operate.webapp.security.OperateURIs;
import jakarta.json.Json;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.logging.LoggersEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class BaseWebConfigurer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected OperateProperties operateProperties;
    @Autowired
    OperateProfileService errorMessageService;
    final CookieCsrfTokenRepository cookieCsrfTokenRepository = new CookieCsrfTokenRepository();

    public static void sendJSONErrorMessage(HttpServletResponse response, String message) throws IOException {
        response.reset();
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        String jsonResponse = Json.createObjectBuilder().add("message", message).build().toString();
        writer.append(jsonResponse);
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
    }

    @Bean
    @Order(value=-2147483648)
    public SecurityFilterChain actuatorFilterChain(HttpSecurity http) throws Exception {
        http.securityMatchers(matchers -> ((HttpSecurity.RequestMatcherConfigurer)matchers.requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).requestMatchers(new String[]{"/error"}));
        return (SecurityFilterChain)this.configureActuatorSecurity(http).authorizeHttpRequests(spec -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)spec.anyRequest()).permitAll()).build();
    }

    private HttpSecurity configureActuatorSecurity(HttpSecurity http) throws Exception {
        return http.csrf(AbstractHttpConfigurer::disable).cors(AbstractHttpConfigurer::disable).logout(AbstractHttpConfigurer::disable).formLogin(AbstractHttpConfigurer::disable).httpBasic(AbstractHttpConfigurer::disable).anonymous(AbstractHttpConfigurer::disable);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        this.applySecurityHeadersSettings(http);
        this.applySecurityFilterSettings(http);
        this.applyAuthenticationSettings(authenticationManagerBuilder);
        this.applyOAuth2Settings(http);
        return (SecurityFilterChain)http.build();
    }

    protected void applySecurityHeadersSettings(HttpSecurity http) throws Exception {
        WebSecurityProperties webSecurityConfig = this.operateProperties.getWebSecurity();
        String policyDirectives = this.operateProperties.getCloud().getClusterId() == null ? "default-src 'self'; base-uri 'self'; script-src 'self'; script-src-elem 'self' cdn.jsdelivr.net; connect-src 'self' cdn.jsdelivr.net; style-src 'self' 'unsafe-inline' cdn.jsdelivr.net; img-src * data:; block-all-mixed-content; form-action 'self'; frame-ancestors 'none'; frame-src 'self' https:; object-src 'none'; font-src 'self' fonts.camunda.io cdn.jsdelivr.net; worker-src 'self' blob:; sandbox allow-forms allow-scripts allow-same-origin allow-popups" : webSecurityConfig.getContentSecurityPolicy();
        http.headers(headers -> headers.contentSecurityPolicy(cps -> cps.policyDirectives(policyDirectives)).httpStrictTransportSecurity(sts -> sts.maxAgeInSeconds(webSecurityConfig.getHttpStrictTransportSecurityMaxAgeInSeconds()).includeSubDomains(webSecurityConfig.getHttpStrictTransportSecurityIncludeSubDomains())));
    }

    protected void applySecurityFilterSettings(HttpSecurity http) throws Exception {
        this.defaultFilterSettings(http);
    }

    private void defaultFilterSettings(HttpSecurity http) throws Exception {
        if (this.operateProperties.isCsrfPreventionEnabled()) {
            this.logger.info("CSRF Protection is enabled");
            this.configureCSRF(http);
        } else {
            http.csrf(csrf -> csrf.disable());
        }
        http.authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.requestMatchers(OperateURIs.AUTH_WHITELIST)).permitAll().requestMatchers(new String[]{"/api/**", "/v*/**"})).authenticated()).formLogin(login -> ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)login.loginProcessingUrl("/api/login")).successHandler(this::successHandler)).failureHandler(this::failureHandler)).permitAll()).logout(logout -> logout.logoutUrl("/api/logout").logoutSuccessHandler(this::logoutSuccessHandler).permitAll().deleteCookies(new String[]{"OPERATE-SESSION", "X-CSRF-TOKEN"}).clearAuthentication(true).invalidateHttpSession(true)).exceptionHandling(handling -> handling.authenticationEntryPoint(this::failureHandler));
    }

    protected void applyAuthenticationSettings(AuthenticationManagerBuilder builder) throws Exception {
    }

    protected abstract void applyOAuth2Settings(HttpSecurity var1) throws Exception;

    protected void logoutSuccessHandler(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void failureHandler(HttpServletRequest request, HttpServletResponse response, AuthenticationException ex) throws IOException {
        String requestedUrl = request.getRequestURI().substring(request.getContextPath().length());
        if (requestedUrl.contains("/api/") || requestedUrl.contains("/v1/") || requestedUrl.contains("/v2/")) {
            this.sendError(request, response, ex);
        } else {
            this.storeRequestedUrlAndRedirectToLogin(request, response, requestedUrl);
        }
    }

    private void storeRequestedUrlAndRedirectToLogin(HttpServletRequest request, HttpServletResponse response, String requestedUrl) throws IOException {
        if (request.getQueryString() != null && !request.getQueryString().isEmpty()) {
            requestedUrl = (String)requestedUrl + "?" + request.getQueryString();
        }
        this.logger.warn("Try to access protected resource {}. Save it for later redirect", requestedUrl);
        request.getSession(true).setAttribute("requestedUrl", requestedUrl);
        response.sendRedirect(request.getContextPath() + "/api/login");
    }

    private void successHandler(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.addCSRFTokenWhenAvailable(request, response).setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void configureCSRF(HttpSecurity http) throws Exception {
        this.cookieCsrfTokenRepository.setHeaderName("X-CSRF-TOKEN");
        this.cookieCsrfTokenRepository.setCookieHttpOnly(true);
        this.cookieCsrfTokenRepository.setCookieName("X-CSRF-TOKEN");
        http.csrf(csrf -> csrf.csrfTokenRepository((CsrfTokenRepository)this.cookieCsrfTokenRepository).requireCsrfProtectionMatcher((RequestMatcher)new CsrfRequireMatcher()).ignoringRequestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{LoggersEndpoint.class})})).addFilterAfter((Filter)this.getCSRFHeaderFilter(), CsrfFilter.class);
    }

    protected OncePerRequestFilter getCSRFHeaderFilter() {
        return new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)BaseWebConfigurer.this.addCSRFTokenWhenAvailable(request, response));
            }
        };
    }

    protected HttpServletResponse addCSRFTokenWhenAvailable(HttpServletRequest request, HttpServletResponse response) {
        CsrfToken token;
        if (this.shouldAddCSRF(request) && (token = (CsrfToken)request.getAttribute(CsrfToken.class.getName())) != null) {
            response.setHeader("X-CSRF-TOKEN", token.getToken());
        }
        return response;
    }

    boolean shouldAddCSRF(HttpServletRequest request) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String path = request.getRequestURI();
        String method = request.getMethod();
        return auth != null && auth.isAuthenticated() && (path == null || !path.contains("logout")) && ("GET".equalsIgnoreCase(method) || path != null && path.contains("login"));
    }

    protected void sendError(HttpServletRequest request, HttpServletResponse response, AuthenticationException ex) throws IOException {
        request.getSession().invalidate();
        BaseWebConfigurer.sendJSONErrorMessage(response, this.errorMessageService.getMessageByProfileFor((Exception)ex));
    }
}

