/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security;

import io.camunda.operate.webapp.rest.dto.UserDto;
import io.camunda.operate.webapp.rest.exception.UserNotFoundException;
import io.camunda.operate.webapp.security.UserService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractUserService<T extends Authentication>
implements UserService<T> {
    @Override
    public UserDto getCurrentUser() {
        T authentication = this.getCurrentAuthentication();
        try {
            return this.createUserDtoFrom(authentication);
        }
        catch (ClassCastException e) {
            LOGGER.error(String.format("Couldn't get matching authentication for %s. Throw UserNotFound exception.", authentication), (Throwable)e);
            throw new UserNotFoundException("Couldn't get authentication for user.");
        }
    }

    @Override
    public String getUserToken() {
        return this.getUserToken(this.getCurrentAuthentication());
    }

    protected T getCurrentAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        return (T)context.getAuthentication();
    }

    public abstract String getUserToken(T var1);
}

