/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.validation;

import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.rest.dto.operation.ModifyProcessInstanceRequestDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ModifyProcessInstanceRequestValidator {
    private final ProcessInstanceReader processInstanceReader;

    public ModifyProcessInstanceRequestValidator(ProcessInstanceReader processInstanceReader) {
        this.processInstanceReader = processInstanceReader;
    }

    public void validate(ModifyProcessInstanceRequestDto modifyRequest) {
        Long processInstanceKey = Long.parseLong(modifyRequest.getProcessInstanceKey());
        if (this.processInstanceReader.getProcessInstanceByKey(processInstanceKey) == null) {
            throw new InvalidRequestException(String.format("Process instance with key %s does not exist", processInstanceKey));
        }
        if (!CollectionUtil.isNotEmpty(modifyRequest.getModifications())) {
            throw new InvalidRequestException(String.format("No modifications given for process instance with key %s", processInstanceKey));
        }
        modifyRequest.getModifications().forEach(modification -> {
            ModifyProcessInstanceRequestDto.Modification.Type type = modification.getModification();
            if (type == ModifyProcessInstanceRequestDto.Modification.Type.ADD_TOKEN) {
                this.validateAddToken((ModifyProcessInstanceRequestDto.Modification)modification, processInstanceKey);
            } else if (type == ModifyProcessInstanceRequestDto.Modification.Type.CANCEL_TOKEN) {
                this.validateCancelToken((ModifyProcessInstanceRequestDto.Modification)modification, processInstanceKey);
            } else if (type == ModifyProcessInstanceRequestDto.Modification.Type.MOVE_TOKEN) {
                this.validateMoveToken((ModifyProcessInstanceRequestDto.Modification)modification, processInstanceKey);
            } else if (type == ModifyProcessInstanceRequestDto.Modification.Type.ADD_VARIABLE || type == ModifyProcessInstanceRequestDto.Modification.Type.EDIT_VARIABLE) {
                this.validateAddEditVariable((ModifyProcessInstanceRequestDto.Modification)modification, processInstanceKey);
            } else {
                throw new InvalidRequestException(String.format("Unknown Modification.Type given for process instance with key %s.", processInstanceKey));
            }
        });
    }

    private void validateAddEditVariable(ModifyProcessInstanceRequestDto.Modification modification, Long processInstanceKey) {
        if (!MapUtils.isNotEmpty(modification.getVariables())) {
            throw new InvalidRequestException(String.format("No variables given for process instance with key %s", processInstanceKey));
        }
    }

    private void validateMoveToken(ModifyProcessInstanceRequestDto.Modification modification, Long processInstanceKey) {
        this.validateAddToken(modification, processInstanceKey);
        this.validateCancelToken(modification, processInstanceKey);
    }

    private void validateCancelToken(ModifyProcessInstanceRequestDto.Modification modification, Long processInstanceKey) {
        if (!StringUtils.hasText((String)modification.getFromFlowNodeId()) && !StringUtils.hasText((String)modification.getFromFlowNodeInstanceKey())) {
            throw new InvalidRequestException(String.format("Neither fromFlowNodeId nor fromFlowNodeInstanceKey is given for process instance with key %s", processInstanceKey));
        }
        if (StringUtils.hasText((String)modification.getFromFlowNodeId()) && StringUtils.hasText((String)modification.getFromFlowNodeInstanceKey())) {
            throw new InvalidRequestException(String.format("Either fromFlowNodeId or fromFlowNodeInstanceKey for process instance with key %s should be given, not both.", processInstanceKey));
        }
        if (modification.getFromFlowNodeInstanceKey() != null) {
            try {
                Long.parseLong(modification.getFromFlowNodeInstanceKey());
            }
            catch (NumberFormatException nfe) {
                throw new InvalidRequestException("fromFlowNodeInstanceKey should be a Long.");
            }
        }
    }

    private void validateAddToken(ModifyProcessInstanceRequestDto.Modification modification, Long processInstanceKey) {
        if (modification.getToFlowNodeId() == null) {
            throw new InvalidRequestException(String.format("No toFlowNodeId given for process instance with key %s", processInstanceKey));
        }
    }
}

