/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.incidents;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentByProcessStatisticsDto;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class IncidentsByProcessGroupStatisticsDto {
    public static final Comparator<IncidentsByProcessGroupStatisticsDto> COMPARATOR = new IncidentsByProcessGroupStatisticsDtoComparator();
    private String bpmnProcessId;
    private String tenantId;
    private String processName;
    private long instancesWithActiveIncidentsCount;
    private long activeInstancesCount;
    @JsonDeserialize(as=TreeSet.class)
    private Set<IncidentByProcessStatisticsDto> processes = new TreeSet<IncidentByProcessStatisticsDto>(IncidentByProcessStatisticsDto.COMPARATOR);

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public IncidentsByProcessGroupStatisticsDto setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public long getInstancesWithActiveIncidentsCount() {
        return this.instancesWithActiveIncidentsCount;
    }

    public void setInstancesWithActiveIncidentsCount(long instancesWithActiveIncidentsCount) {
        this.instancesWithActiveIncidentsCount = instancesWithActiveIncidentsCount;
    }

    public long getActiveInstancesCount() {
        return this.activeInstancesCount;
    }

    public void setActiveInstancesCount(long activeInstancesCount) {
        this.activeInstancesCount = activeInstancesCount;
    }

    public Set<IncidentByProcessStatisticsDto> getProcesses() {
        return this.processes;
    }

    public void setProcesses(Set<IncidentByProcessStatisticsDto> processes) {
        this.processes = processes;
    }

    public int hashCode() {
        return Objects.hash(this.bpmnProcessId, this.tenantId, this.processName, this.instancesWithActiveIncidentsCount, this.activeInstancesCount, this.processes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentsByProcessGroupStatisticsDto that = (IncidentsByProcessGroupStatisticsDto)o;
        return this.instancesWithActiveIncidentsCount == that.instancesWithActiveIncidentsCount && this.activeInstancesCount == that.activeInstancesCount && Objects.equals(this.bpmnProcessId, that.bpmnProcessId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.processName, that.processName) && Objects.equals(this.processes, that.processes);
    }

    public static class IncidentsByProcessGroupStatisticsDtoComparator
    implements Comparator<IncidentsByProcessGroupStatisticsDto> {
        @Override
        public int compare(IncidentsByProcessGroupStatisticsDto o1, IncidentsByProcessGroupStatisticsDto o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int result = Long.compare(o2.getInstancesWithActiveIncidentsCount(), o1.getInstancesWithActiveIncidentsCount());
            if (result == 0 && (result = Long.compare(o2.getActiveInstancesCount(), o1.getActiveInstancesCount())) == 0 && (result = o1.getBpmnProcessId().compareTo(o2.getBpmnProcessId())) == 0) {
                result = o1.getTenantId().compareTo(o2.getTenantId());
            }
            return result;
        }
    }
}

