/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.dmn;

import io.camunda.operate.entities.dmn.definition.DecisionDefinitionEntity;
import io.camunda.operate.webapp.rest.dto.DtoCreator;
import io.camunda.operate.webapp.rest.dto.dmn.DecisionDto;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Schema(name="Decision group object", description="Group of decisions with the same decisionId with all versions included")
public class DecisionGroupDto {
    private String decisionId;
    private String tenantId;
    private String name;
    private Set<String> permissions;
    private List<DecisionDto> decisions;

    public static List<DecisionGroupDto> createFrom(Map<String, List<DecisionDefinitionEntity>> decisionsGrouped) {
        return DecisionGroupDto.createFrom(decisionsGrouped, null);
    }

    public static List<DecisionGroupDto> createFrom(Map<String, List<DecisionDefinitionEntity>> decisionsGrouped, PermissionsService permissionsService) {
        ArrayList<DecisionGroupDto> groups = new ArrayList<DecisionGroupDto>();
        decisionsGrouped.values().stream().forEach(group -> {
            DecisionGroupDto groupDto = new DecisionGroupDto();
            DecisionDefinitionEntity decision0 = (DecisionDefinitionEntity)group.get(0);
            groupDto.setDecisionId(decision0.getDecisionId());
            groupDto.setTenantId(decision0.getTenantId());
            groupDto.setName(decision0.getName());
            groupDto.setPermissions(permissionsService == null ? new HashSet() : permissionsService.getDecisionDefinitionPermission(decision0.getDecisionId()));
            groupDto.setDecisions(DtoCreator.create(group, DecisionDto.class));
            groups.add(groupDto);
        });
        groups.sort(new DecisionGroupComparator());
        return groups;
    }

    public String getDecisionId() {
        return this.decisionId;
    }

    public void setDecisionId(String decisionId) {
        this.decisionId = decisionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public DecisionGroupDto setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public List<DecisionDto> getDecisions() {
        return this.decisions;
    }

    public void setDecisions(List<DecisionDto> decisions) {
        this.decisions = decisions;
    }

    public int hashCode() {
        return Objects.hash(this.decisionId, this.tenantId, this.name, this.permissions, this.decisions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionGroupDto that = (DecisionGroupDto)o;
        return Objects.equals(this.decisionId, that.decisionId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.name, that.name) && Objects.equals(this.permissions, that.permissions) && Objects.equals(this.decisions, that.decisions);
    }

    public static class DecisionGroupComparator
    implements Comparator<DecisionGroupDto> {
        @Override
        public int compare(DecisionGroupDto o1, DecisionGroupDto o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return o1.getDecisionId().compareTo(o2.getDecisionId());
            }
            if (o1.getName() == null) {
                return 1;
            }
            if (o2.getName() == null) {
                return -1;
            }
            if (!o1.getName().equals(o2.getName())) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1.getDecisionId().compareTo(o2.getDecisionId());
        }
    }
}

