/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto;

import io.camunda.operate.webapp.security.Permission;
import io.camunda.operate.webapp.security.sso.model.ClusterMetadata;
import io.camunda.operate.webapp.security.tenant.OperateTenant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class UserDto {
    private String userId;
    private String displayName;
    private boolean canLogout;
    private List<Permission> permissions;
    private List<OperateTenant> tenants;
    private List<String> roles;
    private String salesPlanType;
    private Map<ClusterMetadata.AppName, String> c8Links = new HashMap<ClusterMetadata.AppName, String>();

    public boolean isCanLogout() {
        return this.canLogout;
    }

    public UserDto setCanLogout(boolean canLogout) {
        this.canLogout = canLogout;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDto setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getDisplayName() {
        if (!StringUtils.hasText((String)this.displayName)) {
            return this.userId;
        }
        return this.displayName;
    }

    public UserDto setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String getUsername() {
        return this.getDisplayName();
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public UserDto setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public List<OperateTenant> getTenants() {
        return this.tenants;
    }

    public UserDto setTenants(List<OperateTenant> tenants) {
        this.tenants = tenants;
        return this;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public UserDto setRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public String getSalesPlanType() {
        return this.salesPlanType;
    }

    public UserDto setSalesPlanType(String salesPlanType) {
        this.salesPlanType = salesPlanType;
        return this;
    }

    public Map<ClusterMetadata.AppName, String> getC8Links() {
        return this.c8Links;
    }

    public UserDto setC8Links(Map<ClusterMetadata.AppName, String> c8Links) {
        if (c8Links != null) {
            this.c8Links = c8Links;
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.displayName, this.canLogout, this.permissions, this.roles, this.salesPlanType, this.c8Links);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDto userDto = (UserDto)o;
        return this.canLogout == userDto.canLogout && this.userId.equals(userDto.userId) && this.displayName.equals(userDto.displayName) && this.permissions.equals(userDto.permissions) && Objects.equals(this.roles, userDto.roles) && Objects.equals(this.salesPlanType, userDto.salesPlanType) && Objects.equals(this.c8Links, userDto.c8Links);
    }
}

