/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest;

import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.util.rest.ValidLongId;
import io.camunda.operate.webapp.InternalAPIErrorController;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.reader.ProcessReader;
import io.camunda.operate.webapp.rest.dto.DtoCreator;
import io.camunda.operate.webapp.rest.dto.ProcessDto;
import io.camunda.operate.webapp.rest.dto.ProcessGroupDto;
import io.camunda.operate.webapp.rest.dto.ProcessRequestDto;
import io.camunda.operate.webapp.rest.exception.NotAuthorizedException;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import io.camunda.operate.webapp.writer.BatchOperationWriter;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Processes")
@RestController
@RequestMapping(value={"/api/processes"})
public class ProcessRestService
extends InternalAPIErrorController {
    public static final String PROCESS_URL = "/api/processes";
    @Autowired
    protected ProcessReader processReader;
    @Autowired
    protected ProcessInstanceReader processInstanceReader;
    @Autowired(required=false)
    protected PermissionsService permissionsService;
    @Autowired
    private BatchOperationWriter batchOperationWriter;

    @Operation(summary="Get process BPMN XML")
    @GetMapping(path={"/{id}/xml"})
    public String getProcessDiagram(@PathVariable(value="id") String processId) {
        Long processDefinitionKey = Long.valueOf(processId);
        ProcessEntity processEntity = this.processReader.getProcess(processDefinitionKey);
        this.checkIdentityReadPermission(processEntity.getBpmnProcessId());
        return this.processReader.getDiagram(processDefinitionKey);
    }

    @Operation(summary="Get process by id")
    @GetMapping(path={"/{id}"})
    public ProcessDto getProcess(@PathVariable(value="id") String processId) {
        ProcessEntity processEntity = this.processReader.getProcess(Long.valueOf(processId));
        this.checkIdentityReadPermission(processEntity.getBpmnProcessId());
        return DtoCreator.create(processEntity, ProcessDto.class);
    }

    @Operation(summary="List processes grouped by bpmnProcessId")
    @GetMapping(path={"/grouped"})
    @Deprecated
    public List<ProcessGroupDto> getProcessesGrouped() {
        Map<ProcessStore.ProcessKey, List<ProcessEntity>> processesGrouped = this.processReader.getProcessesGrouped(new ProcessRequestDto());
        return ProcessGroupDto.createFrom(processesGrouped, this.permissionsService);
    }

    @Operation(summary="List processes grouped by bpmnProcessId")
    @PostMapping(path={"/grouped"})
    public List<ProcessGroupDto> getProcessesGrouped(@RequestBody ProcessRequestDto request) {
        Map<ProcessStore.ProcessKey, List<ProcessEntity>> processesGrouped = this.processReader.getProcessesGrouped(request);
        return ProcessGroupDto.createFrom(processesGrouped, this.permissionsService);
    }

    @Operation(summary="Delete process definition and dependant resources")
    @DeleteMapping(path={"/{id}"})
    @PreAuthorize(value="hasPermission('write')")
    public BatchOperationEntity deleteProcessDefinition(@ValidLongId @PathVariable(value="id") String processId) {
        ProcessEntity processEntity = this.processReader.getProcess(Long.valueOf(processId));
        this.checkIdentityDeletePermission(processEntity.getBpmnProcessId());
        return this.batchOperationWriter.scheduleDeleteProcessDefinition(processEntity);
    }

    private void checkIdentityReadPermission(String bpmnProcessId) {
        if (this.permissionsService != null && !this.permissionsService.hasPermissionForProcess(bpmnProcessId, IdentityPermission.READ)) {
            throw new NotAuthorizedException(String.format("No read permission for process %s", bpmnProcessId));
        }
    }

    private void checkIdentityDeletePermission(String bpmnProcessId) {
        if (this.permissionsService != null && !this.permissionsService.hasPermissionForProcess(bpmnProcessId, IdentityPermission.DELETE)) {
            throw new NotAuthorizedException(String.format("No delete permission for process %s", bpmnProcessId));
        }
    }
}

