/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.transform;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.webapp.rest.dto.operation.BatchOperationDto;
import io.camunda.operate.webapp.transform.DataAggregator;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.FiltersBucket;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchDataAggregator
extends DataAggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchDataAggregator.class);
    @Autowired
    protected RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private OperationTemplate operationTemplate;

    @Override
    public Map<String, BatchOperationDto> requestAndAddMetadata(Map<String, BatchOperationDto> resultDtos, List<String> idList) {
        SearchRequest.Builder searchRequestBuilder = this.getSearchRequestByIdWithMetadata(idList);
        try {
            SearchResponse searchResponse = this.richOpenSearchClient.doc().search(searchRequestBuilder, OperationEntity.class);
            StringTermsAggregate idAggregate = ((Aggregate)searchResponse.aggregations().get("batchOperationIdAggregation")).sterms();
            for (StringTermsBucket bucket : idAggregate.buckets().array()) {
                Aggregate metadataAggregate = (Aggregate)bucket.aggregations().get("metadataAggregation");
                Integer failedCount = (int)((FiltersBucket)metadataAggregate.filters().buckets().keyed().get("failedOperationsCount")).docCount();
                Integer completedCount = (int)((FiltersBucket)metadataAggregate.filters().buckets().keyed().get("completedOperationsCount")).docCount();
                resultDtos.get(bucket.key()).setFailedOperationsCount(failedCount).setCompletedOperationsCount(completedCount);
            }
        }
        catch (OperateRuntimeException e) {
            String message = String.format("Exception occurred, while searching for batch operation metadata. %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
        return resultDtos;
    }

    public SearchRequest.Builder getSearchRequestByIdWithMetadata(List<String> batchOperationIds) {
        Query idsQuery = QueryDSL.stringTerms((String)"batchOperationId", batchOperationIds);
        Query failedOperationQuery = QueryDSL.term((String)"state", (String)OperationState.FAILED.name());
        Query completedOperationQuery = QueryDSL.term((String)"state", (String)OperationState.COMPLETED.name());
        return RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ALL).query(idsQuery).aggregations("batchOperationIdAggregation", AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)"batchOperationId", (int)batchOperationIds.size()), Map.of("metadataAggregation", AggregationDSL.filtersAggregation(Map.of("failedOperationsCount", failedOperationQuery, "completedOperationsCount", completedOperationQuery))._toAggregation())));
    }
}

