/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.tenant;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.tenant.TenantCheckApplier;
import io.camunda.operate.webapp.security.tenant.TenantService;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchTenantCheckApplier
implements TenantCheckApplier<Query>,
InitializingBean {
    private static OpensearchTenantCheckApplier instance;
    @Autowired
    private TenantService tenantService;

    public static OpensearchTenantCheckApplier get() {
        return instance;
    }

    public void afterPropertiesSet() throws Exception {
        instance = this;
    }

    public Query apply(Query query) {
        TenantService.AuthenticatedTenants tenants = this.tenantService.getAuthenticatedTenants();
        TenantService.TenantAccessType tenantCheckQueryType = tenants.getTenantAccessType();
        List<String> tenantIds = tenants.getTenantIds();
        return switch (tenantCheckQueryType) {
            case TenantService.TenantAccessType.TENANT_ACCESS_ASSIGNED -> {
                Query tenantTermsQuery = QueryDSL.stringTerms((String)"tenantId", tenantIds);
                yield QueryDSL.and((Query[])new Query[]{tenantTermsQuery, query});
            }
            case TenantService.TenantAccessType.TENANT_ACCESS_NONE -> QueryDSL.matchNone();
            case TenantService.TenantAccessType.TENANT_ACCESS_ALL -> query;
            default -> {
                String message = String.format("Unexpected tenant check query type %s", new Object[]{tenantCheckQueryType});
                throw new OperateRuntimeException(message);
            }
        };
    }
}

