/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.Tuple;
import io.camunda.operate.webapp.opensearch.OpenSearchQueryHelper;
import io.camunda.operate.webapp.reader.ListViewReader;
import io.camunda.operate.webapp.reader.OperationReader;
import io.camunda.operate.webapp.rest.dto.listview.ListViewProcessInstanceDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewRequestDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewResponseDto;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchListViewReader
implements ListViewReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchListViewReader.class);
    private final RichOpenSearchClient richOpenSearchClient;
    private final OpenSearchQueryHelper openSearchQueryHelper;
    private final ObjectMapper objectMapper;
    private final ListViewTemplate listViewTemplate;
    private final OperationReader operationReader;

    public OpensearchListViewReader(RichOpenSearchClient richOpenSearchClient, OpenSearchQueryHelper openSearchQueryHelper, ObjectMapper objectMapper, ListViewTemplate listViewTemplate, OperationReader operationReader) {
        this.richOpenSearchClient = richOpenSearchClient;
        this.openSearchQueryHelper = openSearchQueryHelper;
        this.objectMapper = objectMapper;
        this.listViewTemplate = listViewTemplate;
        this.operationReader = operationReader;
    }

    @Override
    public ListViewResponseDto queryProcessInstances(ListViewRequestDto processInstanceRequest) {
        ListViewResponseDto result = new ListViewResponseDto();
        List<ProcessInstanceForListViewEntity> processInstanceEntities = this.queryListView(processInstanceRequest, result);
        List processInstanceKeys = CollectionUtil.map(processInstanceEntities, processInstanceEntity -> Long.valueOf(processInstanceEntity.getId()));
        Map<Long, List<OperationEntity>> operationsPerProcessInstance = this.operationReader.getOperationsPerProcessInstanceKey(processInstanceKeys);
        List<ListViewProcessInstanceDto> processInstanceDtoList = ListViewProcessInstanceDto.createFrom(processInstanceEntities, operationsPerProcessInstance, this.objectMapper);
        result.setProcessInstances(processInstanceDtoList);
        return result;
    }

    @Override
    public List<ProcessInstanceForListViewEntity> queryListView(ListViewRequestDto processInstanceRequest, ListViewResponseDto result) {
        RequestDSL.QueryType queryType = processInstanceRequest.getQuery().isFinished() ? RequestDSL.QueryType.ALL : RequestDSL.QueryType.ONLY_RUNTIME;
        Query query = QueryDSL.constantScore((Query)QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"joinRelation", (String)"processInstance"), this.openSearchQueryHelper.createQueryFragment(processInstanceRequest.getQuery())})));
        LOGGER.debug("Process instance search request: \n{}", (Object)query);
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.listViewTemplate, (RequestDSL.QueryType)queryType).query(query);
        this.applySorting(searchRequestBuilder, processInstanceRequest);
        searchRequestBuilder.size(processInstanceRequest.getPageSize());
        SearchResponse response = this.richOpenSearchClient.doc().fixedSearch(searchRequestBuilder.build(), ProcessInstanceForListViewEntity.class);
        result.setTotalCount(response.hits().total().value());
        List<ProcessInstanceForListViewEntity> processInstanceEntities = response.hits().hits().stream().map(hit -> {
            ProcessInstanceForListViewEntity entity = (ProcessInstanceForListViewEntity)hit.source();
            entity.setSortValues(hit.sort().toArray());
            return entity;
        }).toList();
        if (processInstanceRequest.getSearchBefore() != null) {
            return CollectionUtil.reversedView(processInstanceEntities);
        }
        return processInstanceEntities;
    }

    @Override
    public Tuple<String, String> getCalledProcessInstanceIdAndNameByFlowNodeInstanceId(String flowNodeInstanceId) {
        String[] calledProcessInstanceId = new String[]{null};
        String[] calledProcessDefinitionName = new String[]{null};
        this.findCalledProcessInstance(flowNodeInstanceId, hit -> {
            ProcessInstanceForListViewEntity source = (ProcessInstanceForListViewEntity)hit.source();
            calledProcessInstanceId[0] = hit.id();
            String processName = source.getProcessName();
            if (processName == null) {
                processName = source.getBpmnProcessId();
            }
            calledProcessDefinitionName[0] = processName;
        });
        return Tuple.of((Object)calledProcessInstanceId[0], (Object)calledProcessDefinitionName[0]);
    }

    private void findCalledProcessInstance(String flowNodeInstanceId, Consumer<Hit<ProcessInstanceForListViewEntity>> processInstanceConsumer) {
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder((String)this.listViewTemplate.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"parentFlowNodeInstanceKey", (String)flowNodeInstanceId))).source(QueryDSL.sourceInclude((String[])new String[]{"processName", "bpmnProcessId"}));
        SearchResponse response = this.richOpenSearchClient.doc().search(request, ProcessInstanceForListViewEntity.class);
        if (response.hits().total().value() >= 1L) {
            processInstanceConsumer.accept((Hit<ProcessInstanceForListViewEntity>)((Hit)response.hits().hits().get(0)));
        }
    }

    private String getSortBy(ListViewRequestDto request) {
        if (request.getSorting() != null) {
            String sortBy = request.getSorting().getSortBy();
            if (sortBy.equals("parentInstanceId")) {
                sortBy = "parentProcessInstanceKey";
            } else if (sortBy.equals("tenant")) {
                sortBy = "tenantId";
            }
            if (sortBy.equals("id")) {
                sortBy = "key";
            }
            return sortBy;
        }
        return null;
    }

    private void applySorting(SearchRequest.Builder searchRequest, ListViewRequestDto request) {
        Object[] querySearchAfter;
        boolean directSorting;
        String sortBy = this.getSortBy(request);
        boolean bl = directSorting = request.getSearchAfter() != null || request.getSearchBefore() == null;
        if (request.getSorting() != null) {
            SortOrder directOrder;
            SortOrder sortOrder = directOrder = "asc".equals(request.getSorting().getSortOrder()) ? SortOrder.Asc : SortOrder.Desc;
            if (directSorting) {
                searchRequest.sort(QueryDSL.sortOptions((String)sortBy, (SortOrder)directOrder, (String)"_last"), new SortOptions[0]);
            } else {
                searchRequest.sort(QueryDSL.sortOptions((String)sortBy, (SortOrder)QueryDSL.reverseOrder((SortOrder)directOrder), (String)"_first"), new SortOptions[0]);
            }
        }
        if (directSorting) {
            searchRequest.sort(QueryDSL.sortOptions((String)"key", (SortOrder)SortOrder.Asc), new SortOptions[0]);
            querySearchAfter = request.getSearchAfter(this.objectMapper);
        } else {
            searchRequest.sort(QueryDSL.sortOptions((String)"key", (SortOrder)SortOrder.Desc), new SortOptions[0]);
            querySearchAfter = request.getSearchBefore(this.objectMapper);
        }
        searchRequest.size(request.getPageSize());
        if (querySearchAfter != null) {
            searchRequest.searchAfter(CollectionUtil.toSafeListOfStrings((Object[])querySearchAfter));
        }
    }
}

