/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.tenant;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.tenant.TenantCheckApplier;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.security.tenant.TenantService;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchTenantCheckApplier
implements TenantCheckApplier<SearchRequest> {
    @Autowired
    private TenantService tenantService;

    public SearchRequest apply(SearchRequest searchRequest) {
        TenantService.AuthenticatedTenants tenants = this.tenantService.getAuthenticatedTenants();
        TenantService.TenantAccessType tenantCheckQueryType = tenants.getTenantAccessType();
        List<String> tenantIds = tenants.getTenantIds();
        QueryBuilder actualQuery = searchRequest.source().query();
        searchRequest.source().query((QueryBuilder)(switch (tenantCheckQueryType) {
            case TenantService.TenantAccessType.TENANT_ACCESS_ASSIGNED -> {
                TermsQueryBuilder tenantTermsQuery = QueryBuilders.termsQuery((String)"tenantId", tenantIds);
                yield ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{tenantTermsQuery, actualQuery});
            }
            case TenantService.TenantAccessType.TENANT_ACCESS_NONE -> ElasticsearchUtil.createMatchNoneQuery();
            case TenantService.TenantAccessType.TENANT_ACCESS_ALL -> actualQuery;
            default -> {
                String message = String.format("Unexpected tenant check query type %s", new Object[]{tenantCheckQueryType});
                throw new OperateRuntimeException(message);
            }
        }));
        return searchRequest;
    }
}

