/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.cache.ProcessCache;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.FlowNodeInstanceEntity;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.dmn.DecisionInstanceState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.DecisionInstanceTemplate;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.elasticsearch.ElasticsearchIncidentStore;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.util.TreePath;
import io.camunda.operate.webapp.data.IncidentDataHolder;
import io.camunda.operate.webapp.elasticsearch.reader.AbstractReader;
import io.camunda.operate.webapp.elasticsearch.reader.IncidentReader;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.rest.FlowNodeInstanceMetadataBuilder;
import io.camunda.operate.webapp.rest.dto.FlowNodeStatisticsDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceQueryDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceRequestDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceResponseDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeStateDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentDto;
import io.camunda.operate.webapp.rest.dto.metadata.DecisionInstanceReferenceDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceBreadcrumbEntryDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceMetadata;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeMetadataDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeMetadataRequestDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.Filters;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class FlowNodeInstanceReader
extends AbstractReader
implements io.camunda.operate.webapp.reader.FlowNodeInstanceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowNodeInstanceReader.class);
    @Autowired
    private FlowNodeInstanceTemplate flowNodeInstanceTemplate;
    @Autowired
    private DecisionInstanceTemplate decisionInstanceTemplate;
    @Autowired
    private IncidentTemplate incidentTemplate;
    @Autowired
    private ProcessCache processCache;
    @Autowired
    private ProcessInstanceReader processInstanceReader;
    @Autowired
    private IncidentReader incidentReader;
    @Autowired
    private FlowNodeInstanceMetadataBuilder flowNodeInstanceMetadataBuilder;

    @Override
    public Map<String, FlowNodeInstanceResponseDto> getFlowNodeInstances(FlowNodeInstanceRequestDto request) {
        HashMap<String, FlowNodeInstanceResponseDto> response = new HashMap<String, FlowNodeInstanceResponseDto>();
        for (FlowNodeInstanceQueryDto query : request.getQueries()) {
            response.put(query.getTreePath(), this.getFlowNodeInstances(query));
        }
        return response;
    }

    @Override
    public FlowNodeMetadataDto getFlowNodeMetadata(String processInstanceId, FlowNodeMetadataRequestDto request) {
        if (request.getFlowNodeId() != null) {
            return this.getMetadataByFlowNodeId(processInstanceId, request.getFlowNodeId(), request.getFlowNodeType());
        }
        if (request.getFlowNodeInstanceId() != null) {
            return this.getMetadataByFlowNodeInstanceId(request.getFlowNodeInstanceId());
        }
        return null;
    }

    @Override
    @Deprecated
    public Map<String, FlowNodeStateDto> getFlowNodeStates(String processInstanceId) {
        String latestFlowNodeAggName = "latestFlowNode";
        String activeFlowNodesAggName = "activeFlowNodes";
        String activeFlowNodesBucketsAggName = "activeFlowNodesBuckets";
        String finishedFlowNodesAggName = "finishedFlowNodes";
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)"processInstanceKey", (String)processInstanceId));
        AbstractAggregationBuilder notCompletedFlowNodesAggs = AggregationBuilders.filter((String)"activeFlowNodes", (QueryBuilder)QueryBuilders.termsQuery((String)"state", (String[])new String[]{FlowNodeState.ACTIVE.name(), FlowNodeState.TERMINATED.name()})).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"activeFlowNodesBuckets").field("flowNodeId")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"latestFlowNode").sort("startDate", SortOrder.DESC).size(1).fetchSource(new String[]{"state", "treePath"}, null)));
        AbstractAggregationBuilder finishedFlowNodesAggs = AggregationBuilders.filter((String)"finishedFlowNodes", (QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)FlowNodeState.COMPLETED)).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"finishedFlowNodesBuckets").field("flowNodeId")).size(10000));
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)query).aggregation((AggregationBuilder)notCompletedFlowNodesAggs).aggregation(this.getIncidentsAgg()).aggregation((AggregationBuilder)finishedFlowNodesAggs).size(0));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            HashSet<String> incidentPaths = new HashSet<String>();
            this.processAggregation(response.getAggregations(), incidentPaths, new Boolean[]{false});
            Set<String> finishedFlowNodes = this.collectFinishedFlowNodes((Filter)response.getAggregations().get("finishedFlowNodes"));
            Filter activeFlowNodesAgg = (Filter)response.getAggregations().get("activeFlowNodes");
            Terms flowNodesAgg = (Terms)activeFlowNodesAgg.getAggregations().get("activeFlowNodesBuckets");
            HashMap<String, FlowNodeStateDto> result = new HashMap<String, FlowNodeStateDto>();
            if (flowNodesAgg != null) {
                for (Terms.Bucket flowNode : flowNodesAgg.getBuckets()) {
                    Map lastFlowNodeFields = ((TopHits)flowNode.getAggregations().get("latestFlowNode")).getHits().getAt(0).getSourceAsMap();
                    FlowNodeStateDto flowNodeState = FlowNodeStateDto.valueOf(lastFlowNodeFields.get("state").toString());
                    if (flowNodeState.equals((Object)FlowNodeStateDto.ACTIVE) && incidentPaths.contains(lastFlowNodeFields.get("treePath"))) {
                        flowNodeState = FlowNodeStateDto.INCIDENT;
                    }
                    result.put(flowNode.getKeyAsString(), flowNodeState);
                }
            }
            for (String finishedFlowNodeId : finishedFlowNodes) {
                if (result.get(finishedFlowNodeId) != null) continue;
                result.put(finishedFlowNodeId, FlowNodeStateDto.COMPLETED);
            }
            return result;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining states for instance flow nodes: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<Long> getFlowNodeInstanceKeysByIdAndStates(Long processInstanceId, String flowNodeId, List<FlowNodeState> states) {
        ArrayList<Long> flowNodeInstanceKeys = new ArrayList<Long>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.flowNodeInstanceTemplate.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"flowNodeId", (String)flowNodeId)).must((QueryBuilder)QueryBuilders.termQuery((String)"processInstanceKey", (Object)processInstanceId)).must((QueryBuilder)QueryBuilders.termsQuery((String)"state", (Collection)states.stream().map(Enum::name).collect(Collectors.toList())))).fetchField("id"));
            SearchHits searchHits = this.tenantAwareClient.search(searchRequest).getHits();
            for (SearchHit searchHit : searchHits) {
                Map documentFields = searchHit.getDocumentFields();
                flowNodeInstanceKeys.add(Long.parseLong((String)((DocumentField)documentFields.get("id")).getValue()));
            }
        }
        catch (IOException e) {
            throw new OperateRuntimeException(String.format("Could not retrieve flowNodeInstanceKey for flowNodeId %s ", flowNodeId), (Throwable)e);
        }
        return flowNodeInstanceKeys;
    }

    @Override
    public Collection<FlowNodeStatisticsDto> getFlowNodeStatisticsForProcessInstance(Long processInstanceId) {
        try {
            SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)"processInstanceKey", (Object)processInstanceId))).aggregation((AggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"flowNodeIdAgg").field("flowNodeId")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"countIncident", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"incident", (boolean)true))))).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"countCanceled", (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)FlowNodeType.MULTI_INSTANCE_BODY)).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)FlowNodeState.TERMINATED))))).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"countCompleted", (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)FlowNodeType.MULTI_INSTANCE_BODY)).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)FlowNodeState.COMPLETED))))).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"countActive", (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)FlowNodeType.MULTI_INSTANCE_BODY)).must((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)FlowNodeState.ACTIVE)).must((QueryBuilder)QueryBuilders.termQuery((String)"incident", (boolean)false))))).size(0));
            SearchResponse response = this.tenantAwareClient.search(request);
            Aggregations aggregations = response.getAggregations();
            Terms flowNodeAgg = (Terms)aggregations.get("flowNodeIdAgg");
            return flowNodeAgg.getBuckets().stream().map(bucket -> new FlowNodeStatisticsDto().setActivityId(bucket.getKeyAsString()).setCanceled(((Filter)bucket.getAggregations().get("countCanceled")).getDocCount()).setIncidents(((Filter)bucket.getAggregations().get("countIncident")).getDocCount()).setCompleted(((Filter)bucket.getAggregations().get("countCompleted")).getDocCount()).setActive(((Filter)bucket.getAggregations().get("countActive")).getDocCount())).collect(Collectors.toList());
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining statistics for process instance flow nodes: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<FlowNodeInstanceEntity> getAllFlowNodeInstances(Long processInstanceKey) {
        TermQueryBuilder processInstanceKeyQuery = QueryBuilders.termQuery((String)"processInstanceKey", (Object)processInstanceKey);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)processInstanceKeyQuery)).sort("position", SortOrder.ASC));
        try {
            return ElasticsearchUtil.scroll((SearchRequest)searchRequest, FlowNodeInstanceEntity.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.esClient);
        }
        catch (IOException e) {
            throw new OperateRuntimeException((Throwable)e);
        }
    }

    private FlowNodeInstanceResponseDto getFlowNodeInstances(FlowNodeInstanceQueryDto request) {
        FlowNodeInstanceResponseDto response = this.queryFlowNodeInstances(request);
        if (request.getSearchAfterOrEqual() != null || request.getSearchBeforeOrEqual() != null) {
            this.adjustResponse(response, request);
        }
        return response;
    }

    private void adjustResponse(FlowNodeInstanceResponseDto response, FlowNodeInstanceQueryDto request) {
        String flowNodeInstanceId = null;
        if (request.getSearchAfterOrEqual() != null) {
            flowNodeInstanceId = (String)request.getSearchAfterOrEqual(this.objectMapper)[1];
        } else if (request.getSearchBeforeOrEqual() != null) {
            flowNodeInstanceId = (String)request.getSearchBeforeOrEqual(this.objectMapper)[1];
        }
        FlowNodeInstanceQueryDto newRequest = request.createCopy().setSearchAfter(null).setSearchAfterOrEqual(null).setSearchBefore(null).setSearchBeforeOrEqual(null);
        List<FlowNodeInstanceDto> entities = this.queryFlowNodeInstances(newRequest, flowNodeInstanceId).getChildren();
        if (entities.size() > 0) {
            FlowNodeInstanceDto entity = entities.get(0);
            List<FlowNodeInstanceDto> children = response.getChildren();
            if (request.getSearchAfterOrEqual() != null) {
                if (request.getPageSize() != null && children.size() == request.getPageSize().intValue()) {
                    children.remove(children.size() - 1);
                }
                children.add(0, entity);
            } else if (request.getSearchBeforeOrEqual() != null) {
                if (request.getPageSize() != null && children.size() == request.getPageSize().intValue()) {
                    children.remove(0);
                }
                children.add(entity);
            }
        }
    }

    private FlowNodeInstanceResponseDto queryFlowNodeInstances(FlowNodeInstanceQueryDto flowNodeInstanceRequest) {
        return this.queryFlowNodeInstances(flowNodeInstanceRequest, null);
    }

    private FlowNodeInstanceResponseDto queryFlowNodeInstances(FlowNodeInstanceQueryDto flowNodeInstanceRequest, String flowNodeInstanceId) {
        String processInstanceId = flowNodeInstanceRequest.getProcessInstanceId();
        String parentTreePath = flowNodeInstanceRequest.getTreePath();
        int level = parentTreePath.split("/").length;
        IdsQueryBuilder idsQuery = null;
        if (flowNodeInstanceId != null) {
            idsQuery = QueryBuilders.idsQuery().addIds(new String[]{flowNodeInstanceId});
        }
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)"processInstanceKey", (String)processInstanceId));
        FilterAggregationBuilder runningParentsAgg = AggregationBuilders.filter((String)"running", (QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"endDate")), QueryBuilders.prefixQuery((String)"treePath", (String)parentTreePath), QueryBuilders.termQuery((String)"level", (int)(level - 1))}));
        QueryBuilder postFilter = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"level", (int)level), QueryBuilders.prefixQuery((String)"treePath", (String)parentTreePath), idsQuery});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).aggregation((AggregationBuilder)runningParentsAgg).postFilter(postFilter);
        if (flowNodeInstanceRequest.getPageSize() != null) {
            searchSourceBuilder.size(flowNodeInstanceRequest.getPageSize().intValue());
        }
        this.applySorting(searchSourceBuilder, flowNodeInstanceRequest);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(searchSourceBuilder);
        try {
            FlowNodeInstanceResponseDto response = flowNodeInstanceRequest.getPageSize() != null ? this.getOnePage(searchRequest, processInstanceId) : this.scrollAllSearchHits(searchRequest, processInstanceId);
            if (level == 1) {
                response.setRunning(null);
            }
            if (flowNodeInstanceRequest.getSearchBefore() != null || flowNodeInstanceRequest.getSearchBeforeOrEqual() != null) {
                Collections.reverse(response.getChildren());
            }
            return response;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all flow node instances: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private AggregationBuilder getIncidentsAgg() {
        return AggregationBuilders.filter((String)"incidents", (QueryBuilder)QueryBuilders.termQuery((String)"incident", (boolean)true)).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"aggIncidentPaths").field("treePath")).size(10000));
    }

    private FlowNodeInstanceResponseDto scrollAllSearchHits(SearchRequest searchRequest, String processInstanceId) throws IOException {
        Boolean[] runningParent = new Boolean[]{false};
        List children = (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, FlowNodeInstanceEntity.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.esClient, this.getSearchHitFunction(null), null, this.getAggsProcessor(null, runningParent)));
        this.markHasIncident(processInstanceId, children);
        return new FlowNodeInstanceResponseDto(runningParent[0], FlowNodeInstanceDto.createFrom(children, this.objectMapper));
    }

    private Function<SearchHit, FlowNodeInstanceEntity> getSearchHitFunction(Set<String> incidentPaths) {
        return sh -> {
            FlowNodeInstanceEntity entity = (FlowNodeInstanceEntity)ElasticsearchUtil.fromSearchHit((String)sh.getSourceAsString(), (ObjectMapper)this.objectMapper, FlowNodeInstanceEntity.class);
            entity.setSortValues(sh.getSortValues());
            if (incidentPaths != null && incidentPaths.contains(entity.getTreePath())) {
                entity.setIncident(true);
            }
            return entity;
        };
    }

    private FlowNodeInstanceResponseDto getOnePage(SearchRequest searchRequest, String processInstanceId) throws IOException {
        SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
        Boolean[] runningParent = new Boolean[1];
        this.processAggregation(searchResponse.getAggregations(), null, runningParent);
        List children = ElasticsearchUtil.mapSearchHits((SearchHit[])searchResponse.getHits().getHits(), this.getSearchHitFunction(null));
        this.markHasIncident(processInstanceId, children);
        return new FlowNodeInstanceResponseDto(runningParent[0], FlowNodeInstanceDto.createFrom(children, this.objectMapper));
    }

    private boolean flowNodeInstanceIsRunningOrIsNotMarked(FlowNodeInstanceEntity flowNodeInstance) {
        return flowNodeInstance.getEndDate() == null || !flowNodeInstance.isIncident();
    }

    private QueryBuilder hasProcessInstanceAsTreePathPrefixAndIsIncident(String treePath) {
        return ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.prefixQuery((String)"treePath", (String)treePath), QueryBuilders.termQuery((String)"incident", (boolean)true)});
    }

    private FiltersAggregator.KeyedFilter newFilterForFlowNodeInstance(FlowNodeInstanceEntity flowNodeInstance) {
        return new FiltersAggregator.KeyedFilter(flowNodeInstance.getId(), this.hasProcessInstanceAsTreePathPrefixAndIsIncident(flowNodeInstance.getTreePath()));
    }

    private void markHasIncident(String processInstanceId, List<FlowNodeInstanceEntity> flowNodeInstances) {
        if (flowNodeInstances == null || flowNodeInstances.isEmpty()) {
            return;
        }
        List<FiltersAggregator.KeyedFilter> filters = flowNodeInstances.stream().filter(this::flowNodeInstanceIsRunningOrIsNotMarked).map(this::newFilterForFlowNodeInstance).toList();
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"processInstanceKey", (String)processInstanceId)).size(0).aggregation((AggregationBuilder)AggregationBuilders.filters((String)"numberOfIncidentsForTreePath", (FiltersAggregator.KeyedFilter[])filters.toArray(new FiltersAggregator.KeyedFilter[0]))));
        try {
            HashMap flowNodeIdIncidents = new HashMap();
            SearchResponse response = this.tenantAwareClient.search(request);
            Filters filterBuckets = (Filters)response.getAggregations().get("numberOfIncidentsForTreePath");
            filterBuckets.getBuckets().forEach(b -> flowNodeIdIncidents.put(b.getKeyAsString(), b.getDocCount()));
            for (FlowNodeInstanceEntity flowNodeInstance : flowNodeInstances) {
                Long count = flowNodeIdIncidents.getOrDefault(flowNodeInstance.getId(), 0L);
                if (count <= 0L) continue;
                flowNodeInstance.setIncident(true);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not retrieve flow node incidents", (Throwable)e);
        }
    }

    private Consumer<Aggregations> getAggsProcessor(Set<String> incidentPaths, Boolean[] runningParent) {
        return aggs -> {
            Terms termsAggs;
            Filter filterAggs;
            if (incidentPaths != null && (filterAggs = (Filter)aggs.get("incidents")) != null && (termsAggs = (Terms)filterAggs.getAggregations().get("aggIncidentPaths")) != null) {
                incidentPaths.addAll(termsAggs.getBuckets().stream().map(b -> b.getKeyAsString()).collect(Collectors.toSet()));
            }
            if ((filterAggs = (Filter)aggs.get("running")) != null && filterAggs.getDocCount() > 0L) {
                runningParent[0] = true;
            }
        };
    }

    private Set<String> processAggregation(Aggregations aggregations, Set<String> incidentPaths, Boolean[] runningParent) {
        this.getAggsProcessor(incidentPaths, runningParent).accept(aggregations);
        return incidentPaths;
    }

    private void applySorting(SearchSourceBuilder searchSourceBuilder, FlowNodeInstanceQueryDto request) {
        boolean directSorting;
        boolean bl = directSorting = request.getSearchAfter() != null || request.getSearchAfterOrEqual() != null || request.getSearchBefore() == null && request.getSearchBeforeOrEqual() == null;
        if (directSorting) {
            searchSourceBuilder.sort("startDate", SortOrder.ASC).sort("id", SortOrder.ASC);
            if (request.getSearchAfter() != null) {
                searchSourceBuilder.searchAfter(request.getSearchAfter(this.objectMapper));
            } else if (request.getSearchAfterOrEqual() != null) {
                searchSourceBuilder.searchAfter(request.getSearchAfterOrEqual(this.objectMapper));
            }
        } else {
            searchSourceBuilder.sort("startDate", SortOrder.DESC).sort("id", SortOrder.DESC);
            if (request.getSearchBefore() != null) {
                searchSourceBuilder.searchAfter(request.getSearchBefore(this.objectMapper));
            } else if (request.getSearchBeforeOrEqual() != null) {
                searchSourceBuilder.searchAfter(request.getSearchBeforeOrEqual(this.objectMapper));
            }
        }
    }

    private FlowNodeMetadataDto getMetadataByFlowNodeInstanceId(String flowNodeInstanceId) {
        FlowNodeInstanceEntity flowNodeInstance = this.getFlowNodeInstanceEntity(flowNodeInstanceId);
        FlowNodeMetadataDto result = new FlowNodeMetadataDto();
        result.setInstanceMetadata(this.buildInstanceMetadata(flowNodeInstance));
        result.setFlowNodeInstanceId(flowNodeInstanceId);
        result.setBreadcrumb(this.buildBreadcrumb(flowNodeInstance.getTreePath(), flowNodeInstance.getFlowNodeId(), flowNodeInstance.getLevel()));
        this.searchForIncidents(result, String.valueOf(flowNodeInstance.getProcessInstanceKey()), flowNodeInstance.getFlowNodeId(), flowNodeInstance.getId(), flowNodeInstance.getType());
        return result;
    }

    private void searchForIncidents(FlowNodeMetadataDto flowNodeMetadata, String processInstanceId, String flowNodeId, String flowNodeInstanceId, FlowNodeType flowNodeType) {
        String treePath = this.processInstanceReader.getProcessInstanceTreePath(processInstanceId);
        String incidentTreePath = new TreePath(treePath).appendFlowNode(flowNodeId).appendFlowNodeInstance(flowNodeInstanceId).toString();
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"treePath", (String)incidentTreePath), ElasticsearchIncidentStore.ACTIVE_INCIDENT_QUERY}));
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.incidentTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query((QueryBuilder)query));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            flowNodeMetadata.setIncidentCount(response.getHits().getTotalHits().value);
            if (response.getHits().getTotalHits().value == 1L) {
                IncidentEntity incidentEntity = (IncidentEntity)ElasticsearchUtil.fromSearchHit((String)response.getHits().getAt(0).getSourceAsString(), (ObjectMapper)this.objectMapper, IncidentEntity.class);
                Map<String, IncidentDataHolder> incData = this.incidentReader.collectFlowNodeDataForPropagatedIncidents(List.of(incidentEntity), processInstanceId, treePath);
                DecisionInstanceReferenceDto rootCauseDecision = null;
                if (flowNodeType.equals((Object)FlowNodeType.BUSINESS_RULE_TASK)) {
                    rootCauseDecision = this.findRootCauseDecision(incidentEntity.getFlowNodeInstanceKey());
                }
                IncidentDto incidentDto = IncidentDto.createFrom(incidentEntity, Map.of(incidentEntity.getProcessDefinitionKey(), this.processCache.getProcessNameOrBpmnProcessId(incidentEntity.getProcessDefinitionKey(), "Unknown process")), incData.get(incidentEntity.getId()), rootCauseDecision);
                flowNodeMetadata.setIncident(incidentDto);
            }
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining incidents: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private void searchForIncidentsByFlowNodeIdAndType(FlowNodeMetadataDto flowNodeMetadata, String processInstanceId, String flowNodeId, FlowNodeType flowNodeType) {
        String treePath = this.processInstanceReader.getProcessInstanceTreePath(processInstanceId);
        String flowNodeInstancesTreePath = new TreePath(treePath).appendFlowNode(flowNodeId).toString();
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"treePath", (String)flowNodeInstancesTreePath), ElasticsearchIncidentStore.ACTIVE_INCIDENT_QUERY}));
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.incidentTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query((QueryBuilder)query));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            flowNodeMetadata.setIncidentCount(response.getHits().getTotalHits().value);
            if (response.getHits().getTotalHits().value == 1L) {
                IncidentEntity incidentEntity = (IncidentEntity)ElasticsearchUtil.fromSearchHit((String)response.getHits().getAt(0).getSourceAsString(), (ObjectMapper)this.objectMapper, IncidentEntity.class);
                Map<String, IncidentDataHolder> incData = this.incidentReader.collectFlowNodeDataForPropagatedIncidents(List.of(incidentEntity), processInstanceId, treePath);
                DecisionInstanceReferenceDto rootCauseDecision = null;
                if (flowNodeType.equals((Object)FlowNodeType.BUSINESS_RULE_TASK)) {
                    rootCauseDecision = this.findRootCauseDecision(incidentEntity.getFlowNodeInstanceKey());
                }
                IncidentDto incidentDto = IncidentDto.createFrom(incidentEntity, Map.of(incidentEntity.getProcessDefinitionKey(), this.processCache.getProcessNameOrBpmnProcessId(incidentEntity.getProcessDefinitionKey(), "Unknown process")), incData.get(incidentEntity.getId()), rootCauseDecision);
                flowNodeMetadata.setIncident(incidentDto);
            }
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining incidents: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private DecisionInstanceReferenceDto findRootCauseDecision(Long flowNodeInstanceKey) {
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.decisionInstanceTemplate).source(new SearchSourceBuilder().query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"elementInstanceKey", (Object)flowNodeInstanceKey), QueryBuilders.termQuery((String)"state", (Object)DecisionInstanceState.FAILED)})).sort("evaluationDate", SortOrder.DESC).size(1).fetchSource(new String[]{"decisionName", "decisionId"}, null));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value > 0L) {
                Map source = response.getHits().getHits()[0].getSourceAsMap();
                String decisionName = (String)source.get("decisionName");
                if (decisionName == null) {
                    decisionName = (String)source.get("decisionId");
                }
                return new DecisionInstanceReferenceDto().setDecisionName(decisionName).setInstanceId(response.getHits().getHits()[0].getId());
            }
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while searching for root cause decision. Flow node instance id: %s. Error message: %s.", flowNodeInstanceKey, e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
        return null;
    }

    private FlowNodeInstanceEntity getFlowNodeInstanceEntity(String flowNodeInstanceId) {
        FlowNodeInstanceEntity flowNodeInstance;
        TermQueryBuilder flowNodeInstanceIdQ = QueryBuilders.termQuery((String)"id", (String)flowNodeInstanceId);
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)flowNodeInstanceIdQ)));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            flowNodeInstance = this.getFlowNodeInstance(response);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining metadata for flow node instance: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
        return flowNodeInstance;
    }

    private List<FlowNodeInstanceBreadcrumbEntryDto> buildBreadcrumb(String treePath, String flowNodeId, int level) {
        ArrayList<FlowNodeInstanceBreadcrumbEntryDto> result = new ArrayList<FlowNodeInstanceBreadcrumbEntryDto>();
        int lastSeparatorIndex = treePath.lastIndexOf("/");
        String prefixTreePath = lastSeparatorIndex > -1 ? treePath.substring(0, lastSeparatorIndex) : treePath;
        QueryBuilder query = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"flowNodeId", (String)flowNodeId), QueryBuilders.prefixQuery((String)"treePath", (String)prefixTreePath), QueryBuilders.rangeQuery((String)"level").lte((Object)level)});
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)).fetchSource(false).size(0).aggregation((AggregationBuilder)this.getLevelsAggs()));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            Terms levelsAgg = (Terms)response.getAggregations().get("levelsAgg");
            result.addAll(this.buildBreadcrumbForFlowNodeId(levelsAgg.getBuckets(), level));
            return result;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining metadata for flow node: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private FlowNodeMetadataDto getMetadataByFlowNodeId(String processInstanceId, String flowNodeId, FlowNodeType flowNodeType) {
        TermQueryBuilder processInstanceIdQ = QueryBuilders.termQuery((String)"processInstanceKey", (String)processInstanceId);
        TermQueryBuilder flowNodeIdQ = QueryBuilders.termQuery((String)"flowNodeId", (String)flowNodeId);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{processInstanceIdQ, flowNodeIdQ}))).sort("level", SortOrder.ASC).aggregation((AggregationBuilder)this.getLevelsAggs()).size(1);
        if (flowNodeType != null) {
            sourceBuilder.postFilter((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)flowNodeType));
        }
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.flowNodeInstanceTemplate).source(sourceBuilder);
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            FlowNodeMetadataDto result = new FlowNodeMetadataDto();
            FlowNodeInstanceEntity flowNodeInstance = this.getFlowNodeInstance(response);
            Terms levelsAgg = (Terms)response.getAggregations().get("levelsAgg");
            if (levelsAgg != null && levelsAgg.getBuckets() != null && levelsAgg.getBuckets().size() > 0) {
                Terms.Bucket bucketCurrentLevel = this.getBucketFromLevel(levelsAgg.getBuckets(), flowNodeInstance.getLevel());
                if (bucketCurrentLevel.getDocCount() == 1L) {
                    result.setInstanceMetadata(this.buildInstanceMetadata(flowNodeInstance));
                    result.setFlowNodeInstanceId(flowNodeInstance.getId());
                    result.setBreadcrumb(this.buildBreadcrumbForFlowNodeId(levelsAgg.getBuckets(), flowNodeInstance.getLevel()));
                    this.searchForIncidents(result, String.valueOf(flowNodeInstance.getProcessInstanceKey()), flowNodeInstance.getFlowNodeId(), flowNodeInstance.getId(), flowNodeInstance.getType());
                } else {
                    result.setInstanceCount(bucketCurrentLevel.getDocCount());
                    result.setFlowNodeId(flowNodeInstance.getFlowNodeId());
                    result.setFlowNodeType(flowNodeInstance.getType());
                    this.searchForIncidentsByFlowNodeIdAndType(result, String.valueOf(flowNodeInstance.getProcessInstanceKey()), flowNodeInstance.getFlowNodeId(), flowNodeInstance.getType());
                }
            }
            return result;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining metadata for flow node: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private Terms.Bucket getBucketFromLevel(List<? extends Terms.Bucket> buckets, int level) {
        return buckets.stream().filter(b -> b.getKeyAsNumber().intValue() == level).findFirst().get();
    }

    private TermsAggregationBuilder getLevelsAggs() {
        return (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"levelsAgg").field("level")).size(10000).order(BucketOrder.key((boolean)true)).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"levelsTopHitsAgg").size(1));
    }

    private FlowNodeInstanceEntity getFlowNodeInstance(SearchResponse response) {
        if (response.getHits().getTotalHits().value == 0L) {
            throw new OperateRuntimeException("No data found for flow node instance.");
        }
        return (FlowNodeInstanceEntity)ElasticsearchUtil.fromSearchHit((String)response.getHits().getAt(0).getSourceAsString(), (ObjectMapper)this.objectMapper, FlowNodeInstanceEntity.class);
    }

    private List<FlowNodeInstanceBreadcrumbEntryDto> buildBreadcrumbForFlowNodeId(List<? extends Terms.Bucket> buckets, int currentInstanceLevel) {
        if (buckets.size() == 0) {
            return new ArrayList<FlowNodeInstanceBreadcrumbEntryDto>();
        }
        ArrayList<FlowNodeInstanceBreadcrumbEntryDto> breadcrumb = new ArrayList<FlowNodeInstanceBreadcrumbEntryDto>();
        FlowNodeType firstBucketFlowNodeType = this.getFirstBucketFlowNodeType(buckets);
        if (firstBucketFlowNodeType != null && firstBucketFlowNodeType.equals((Object)FlowNodeType.MULTI_INSTANCE_BODY) || this.getBucketFromLevel(buckets, currentInstanceLevel).getDocCount() > 1L) {
            for (Terms.Bucket bucket : buckets) {
                TopHits levelTopHits = (TopHits)bucket.getAggregations().get("levelsTopHitsAgg");
                Map instanceFields = levelTopHits.getHits().getAt(0).getSourceAsMap();
                if ((Integer)instanceFields.get("level") > currentInstanceLevel) continue;
                breadcrumb.add(new FlowNodeInstanceBreadcrumbEntryDto((String)instanceFields.get("flowNodeId"), FlowNodeType.valueOf((String)((String)instanceFields.get("type")))));
            }
        }
        return breadcrumb;
    }

    private FlowNodeType getFirstBucketFlowNodeType(List<? extends Terms.Bucket> buckets) {
        String type;
        TopHits topHits = (TopHits)buckets.get(0).getAggregations().get("levelsTopHitsAgg");
        if (topHits != null && topHits.getHits().getTotalHits().value > 0L && (type = (String)topHits.getHits().getAt(0).getSourceAsMap().get("type")) != null) {
            return FlowNodeType.valueOf((String)type);
        }
        return null;
    }

    private FlowNodeInstanceMetadata buildInstanceMetadata(FlowNodeInstanceEntity flowNodeInstance) {
        return this.flowNodeInstanceMetadataBuilder.buildFrom(flowNodeInstance);
    }

    private Set<String> collectFinishedFlowNodes(Filter finishedFlowNodes) {
        HashSet<String> result = new HashSet<String>();
        List buckets = ((Terms)finishedFlowNodes.getAggregations().get("finishedFlowNodesBuckets")).getBuckets();
        if (buckets != null) {
            for (Terms.Bucket bucket : buckets) {
                result.add(bucket.getKeyAsString());
            }
        }
        return result;
    }
}

