/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.JobEntity;
import io.camunda.operate.entities.ListenerType;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.JobTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.elasticsearch.reader.AbstractReader;
import io.camunda.operate.webapp.reader.ListenerReader;
import io.camunda.operate.webapp.rest.dto.ListenerDto;
import io.camunda.operate.webapp.rest.dto.ListenerRequestDto;
import io.camunda.operate.webapp.rest.dto.ListenerResponseDto;
import io.camunda.operate.webapp.rest.dto.listview.SortValuesWrapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchListenerReader
extends AbstractReader
implements ListenerReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchListenerReader.class);
    private final JobTemplate jobTemplate;
    private final RestHighLevelClient esClient;

    public ElasticsearchListenerReader(JobTemplate jobTemplate, RestHighLevelClient esClient) {
        this.jobTemplate = jobTemplate;
        this.esClient = esClient;
    }

    @Override
    public ListenerResponseDto getListenerExecutions(String processInstanceId, ListenerRequestDto request) {
        List listeners;
        Long totalHitCount;
        TermQueryBuilder processInstanceQ = QueryBuilders.termQuery((String)"processInstanceKey", (String)processInstanceId);
        TermQueryBuilder flowNodeIdQ = QueryBuilders.termQuery((String)"flowNodeId", (String)request.getFlowNodeId());
        TermQueryBuilder executionListenersQ = QueryBuilders.termQuery((String)"jobKind", (Object)ListenerType.EXECUTION_LISTENER);
        TermQueryBuilder taskListenersQ = QueryBuilders.termQuery((String)"jobKind", (Object)ListenerType.TASK_LISTENER);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{processInstanceQ, flowNodeIdQ, ElasticsearchUtil.joinWithOr((QueryBuilder[])new QueryBuilder[]{executionListenersQ, taskListenersQ})})).size(request.getPageSize().intValue());
        this.applySorting(sourceBuilder, request);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.jobTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ALL).source(sourceBuilder);
        try {
            SearchResponse response = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            totalHitCount = response.getHits().getTotalHits().value;
            listeners = ElasticsearchUtil.mapSearchHits((SearchHit[])response.getHits().getHits(), searchHit -> {
                JobEntity entity = (JobEntity)ElasticsearchUtil.fromSearchHit((String)searchHit.getSourceAsString(), (ObjectMapper)this.objectMapper, JobEntity.class);
                ListenerDto dto = ListenerDto.fromJobEntity(entity);
                SortValuesWrapper[] sortValues = SortValuesWrapper.createFrom(searchHit.getSortValues(), this.objectMapper);
                dto.setSortValues(sortValues);
                return dto;
            });
            if (request.getSearchBefore() != null) {
                Collections.reverse(listeners);
            }
        }
        catch (IOException e) {
            String message = String.format("Exception occurred while searching for listeners: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
        return new ListenerResponseDto(listeners, totalHitCount);
    }

    private void applySorting(SearchSourceBuilder searchSourceBuilder, ListenerRequestDto request) {
        String missing;
        SortOrder sortOrder = SortOrder.DESC;
        if (request.getSorting() != null && request.getSorting().getSortOrder() != null) {
            sortOrder = SortOrder.fromString((String)request.getSorting().getSortOrder());
        }
        Object[] querySearchAfter = null;
        if (request.getSearchBefore() != null) {
            sortOrder = ElasticsearchUtil.reverseOrder((SortOrder)sortOrder);
            missing = "_last";
            querySearchAfter = request.getSearchBefore(this.objectMapper);
        } else {
            missing = "_first";
            if (request.getSearchAfter() != null) {
                querySearchAfter = request.getSearchAfter(this.objectMapper);
            }
        }
        if (querySearchAfter != null) {
            searchSourceBuilder.searchAfter(querySearchAfter);
        }
        searchSourceBuilder.sort((SortBuilder)((FieldSortBuilder)SortBuilders.fieldSort((String)"endTime").order(sortOrder)).missing((Object)missing)).sort(SortBuilders.fieldSort((String)"key").order(sortOrder));
    }
}

