/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.opensearch;

import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.webapp.api.v1.dao.opensearch.OpensearchSearchableDao;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import io.camunda.operate.webapp.opensearch.OpensearchQueryDSLWrapper;
import io.camunda.operate.webapp.opensearch.OpensearchRequestDSLWrapper;
import java.util.List;
import org.opensearch.client.opensearch.core.SearchRequest;

public abstract class OpensearchKeyFilteringDao<T, R>
extends OpensearchSearchableDao<T, R> {
    public OpensearchKeyFilteringDao(OpensearchQueryDSLWrapper queryDSLWrapper, OpensearchRequestDSLWrapper requestDSLWrapper, RichOpenSearchClient richOpenSearchClient) {
        super(queryDSLWrapper, requestDSLWrapper, richOpenSearchClient);
    }

    public T byKey(Long key) {
        List<R> results;
        this.validateKey(key);
        try {
            results = this.searchByKey(key);
        }
        catch (Exception e) {
            throw new ServerException(this.getByKeyServerReadErrorMessage(key), e);
        }
        if (results == null || results.isEmpty()) {
            throw new ResourceNotFoundException(this.getByKeyNoResultsErrorMessage(key));
        }
        if (results.size() > 1) {
            throw new ServerException(this.getByKeyTooManyResultsErrorMessage(key));
        }
        return this.convertInternalToApiResult(results.get(0));
    }

    protected List<R> searchByKey(Long key) {
        SearchRequest.Builder request = this.requestDSLWrapper.searchRequestBuilder(this.getIndexName()).query(this.queryDSLWrapper.withTenantCheck(this.queryDSLWrapper.term(this.getKeyFieldName(), key)));
        return this.richOpenSearchClient.doc().searchValues(request, this.getInternalDocumentModelClass());
    }

    protected void validateKey(Long key) {
        if (key == null) {
            throw new ServerException("Key provided cannot be null");
        }
    }

    protected abstract String getKeyFieldName();

    protected abstract String getByKeyServerReadErrorMessage(Long var1);

    protected abstract String getByKeyNoResultsErrorMessage(Long var1);

    protected abstract String getByKeyTooManyResultsErrorMessage(Long var1);
}

