/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.indices.ProcessIndex;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.ProcessDefinitionDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.ProcessDefinition;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchProcessDefinitionDaoV1")
public class ElasticsearchProcessDefinitionDao
extends ElasticsearchDao<ProcessDefinition>
implements ProcessDefinitionDao {
    @Autowired
    private ProcessIndex processIndex;

    @Override
    public Results<ProcessDefinition> search(Query<ProcessDefinition> query) throws APIException {
        this.logger.debug("search {}", query);
        SearchSourceBuilder searchSourceBuilder = this.buildQueryOn(query, "key", new SearchSourceBuilder());
        try {
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.processIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                Object[] sortValues = searchHitArray[searchHitArray.length - 1].getSortValues();
                return new Results().setTotal(searchHits.getTotalHits().value).setItems(ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, (ObjectMapper)this.objectMapper, ProcessDefinition.class)).setSortValues(sortValues);
            }
            return new Results().setTotal(searchHits.getTotalHits().value);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading process definitions", e);
        }
    }

    @Override
    public ProcessDefinition byKey(Long key) throws APIException {
        List<ProcessDefinition> processDefinitions;
        this.logger.debug("byKey {}", (Object)key);
        try {
            processDefinitions = this.searchFor(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)key)));
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading process definition for key %s", key), e);
        }
        if (processDefinitions.isEmpty()) {
            throw new ResourceNotFoundException(String.format("No process definition found for key %s ", key));
        }
        if (processDefinitions.size() > 1) {
            throw new ServerException(String.format("Found more than one process definition for key %s", key));
        }
        return processDefinitions.get(0);
    }

    @Override
    public String xmlByKey(Long key) throws APIException {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)key)).fetchSource("bpmnXml", null));
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 1L) {
                Map result = response.getHits().getHits()[0].getSourceAsMap();
                return (String)result.get("bpmnXml");
            }
        }
        catch (IOException e) {
            throw new ServerException(String.format("Error in reading process definition as xml for key %s", key), e);
        }
        throw new ResourceNotFoundException(String.format("Process definition for key %s not found.", key));
    }

    @Override
    protected void buildFiltering(Query<ProcessDefinition> query, SearchSourceBuilder searchSourceBuilder) {
        ProcessDefinition filter = query.getFilter();
        if (filter != null) {
            ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
            queryBuilders.add(this.buildTermQuery("name", filter.getName()));
            queryBuilders.add(this.buildTermQuery("bpmnProcessId", filter.getBpmnProcessId()));
            queryBuilders.add(this.buildTermQuery("tenantId", filter.getTenantId()));
            queryBuilders.add(this.buildTermQuery("version", filter.getVersion()));
            queryBuilders.add(this.buildTermQuery("key", filter.getKey()));
            searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
        }
    }

    protected List<ProcessDefinition> searchFor(SearchSourceBuilder searchSource) throws IOException {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(searchSource);
        return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, ProcessDefinition.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.elasticsearch));
    }
}

