/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.IncidentDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.Incident;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchIncidentDaoV1")
public class ElasticsearchIncidentDao
extends ElasticsearchDao<Incident>
implements IncidentDao {
    @Autowired
    private IncidentTemplate incidentIndex;

    @Override
    protected void buildFiltering(Query<Incident> query, SearchSourceBuilder searchSourceBuilder) {
        Incident filter = query.getFilter();
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        if (filter != null) {
            queryBuilders.add(this.buildTermQuery("key", filter.getKey()));
            queryBuilders.add(this.buildTermQuery("processDefinitionKey", filter.getProcessDefinitionKey()));
            queryBuilders.add(this.buildTermQuery("processInstanceKey", filter.getProcessInstanceKey()));
            queryBuilders.add(this.buildTermQuery("errorType", filter.getType()));
            queryBuilders.add(this.buildMatchQuery("errorMessage", filter.getMessage()));
            queryBuilders.add(this.buildTermQuery("state", filter.getState()));
            queryBuilders.add(this.buildTermQuery("jobKey", filter.getJobKey()));
            queryBuilders.add(this.buildTermQuery("tenantId", filter.getTenantId()));
            queryBuilders.add(this.buildMatchDateQuery("creationTime", filter.getCreationTime()));
        }
        searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
    }

    @Override
    public Incident byKey(Long key) throws APIException {
        List<Incident> incidents;
        this.logger.debug("byKey {}", (Object)key);
        try {
            incidents = this.searchFor(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)key)));
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading incident for key %s", key), e);
        }
        if (incidents.isEmpty()) {
            throw new ResourceNotFoundException(String.format("No incident found for key %s ", key));
        }
        if (incidents.size() > 1) {
            throw new ServerException(String.format("Found more than one incidents for key %s", key));
        }
        return incidents.get(0);
    }

    @Override
    public Results<Incident> search(Query<Incident> query) throws APIException {
        this.logger.debug("search {}", query);
        this.mapFieldsInSort(query);
        SearchSourceBuilder searchSourceBuilder = this.buildQueryOn(query, "key", new SearchSourceBuilder());
        try {
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.incidentIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                Object[] sortValues = searchHitArray[searchHitArray.length - 1].getSortValues();
                List incidents = ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, this::searchHitToIncident);
                return new Results().setTotal(searchHits.getTotalHits().value).setItems(incidents).setSortValues(sortValues);
            }
            return new Results().setTotal(searchHits.getTotalHits().value);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading incidents", e);
        }
    }

    private void mapFieldsInSort(Query<Incident> query) {
        if (query.getSort() == null) {
            return;
        }
        query.setSort(query.getSort().stream().map(s -> s.setField(Incident.OBJECT_TO_SEARCH_MAP.getOrDefault(s.getField(), s.getField()))).collect(Collectors.toList()));
    }

    protected Incident searchHitToIncident(SearchHit searchHit) {
        Map searchHitAsMap = searchHit.getSourceAsMap();
        return new Incident().setKey((Long)searchHitAsMap.get("key")).setProcessInstanceKey((Long)searchHitAsMap.get("processInstanceKey")).setProcessDefinitionKey((Long)searchHitAsMap.get("processDefinitionKey")).setType((String)searchHitAsMap.get("errorType")).setMessage((String)searchHitAsMap.get("errorMessage")).setCreationTime(this.dateTimeFormatter.convertGeneralToApiDateTime((String)searchHitAsMap.get("creationTime"))).setState((String)searchHitAsMap.get("state")).setJobKey((Long)searchHitAsMap.get("jobKey")).setTenantId((String)searchHitAsMap.get("tenantId"));
    }

    protected List<Incident> searchFor(SearchSourceBuilder searchSourceBuilder) {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.incidentIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                return ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, this::searchHitToIncident);
            }
            return List.of();
        }
        catch (Exception e) {
            throw new ServerException("Error in reading incidents", e);
        }
    }
}

