/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp;

import io.camunda.operate.OperateProfileService;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.webapp.rest.exception.Error;
import io.camunda.operate.webapp.rest.exception.InternalAPIException;
import io.camunda.operate.webapp.rest.exception.NotAuthorizedException;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class InternalAPIErrorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalAPIErrorController.class);
    @Autowired
    private OperateProfileService operateProfileService;

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={OperateRuntimeException.class})
    public ResponseEntity<Error> handleOperateRuntimeException(OperateRuntimeException exception) {
        LOGGER.warn(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()).setMessage(this.operateProfileService.getMessageByProfileFor((Exception)((Object)exception)));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={io.camunda.operate.store.NotFoundException.class})
    public ResponseEntity<Error> handleRuntimeNotFoundException(io.camunda.operate.store.NotFoundException exception) {
        LOGGER.warn(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setStatus(HttpStatus.NOT_FOUND.value()).setMessage(this.operateProfileService.getMessageByProfileFor((Exception)((Object)exception)));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={InternalAPIException.class})
    public ResponseEntity<Error> handleInternalAPIException(InternalAPIException exception) {
        LOGGER.warn(String.format("Instance: %s; %s", exception.getInstance(), exception.getMessage()));
        Error error = new Error().setStatus(HttpStatus.BAD_REQUEST.value()).setInstance(exception.getInstance()).setMessage(this.operateProfileService.getMessageByProfileFor((Exception)exception));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity<Error> handleInternalNotFoundException(NotFoundException exception) {
        LOGGER.warn(String.format("Instance: %s; %s", exception.getInstance(), exception.getMessage()));
        Error error = new Error().setStatus(HttpStatus.NOT_FOUND.value()).setInstance(exception.getInstance()).setMessage(this.operateProfileService.getMessageByProfileFor((Exception)exception));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={NotAuthorizedException.class})
    public ResponseEntity<Error> handleNotAuthorizedException(NotAuthorizedException exception) {
        LOGGER.warn(String.format("Instance: %s; %s", exception.getInstance(), exception.getMessage()));
        Error error = new Error().setStatus(HttpStatus.FORBIDDEN.value()).setInstance(exception.getInstance()).setMessage(this.operateProfileService.getMessageByProfileFor((Exception)exception));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }
}

