/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.store.opensearch.client.async.OpenSearchAsyncDocumentOperations;
import io.camunda.operate.store.opensearch.client.async.OpenSearchAsyncIndexOperations;
import io.camunda.operate.store.opensearch.client.async.OpenSearchAsyncSnapshotOperations;
import io.camunda.operate.store.opensearch.client.async.OpenSearchAsyncTaskOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchBatchOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchClusterOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchDocumentOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchISMOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchIndexOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchPipelineOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchSnapshotOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchTaskOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchTemplateOperations;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class RichOpenSearchClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RichOpenSearchClient.class);
    final Async async;
    final OpenSearchBatchOperations openSearchBatchOperations;
    final OpenSearchClusterOperations openSearchClusterOperations;
    final OpenSearchDocumentOperations openSearchDocumentOperations;
    final OpenSearchIndexOperations openSearchIndexOperations;
    final OpenSearchPipelineOperations openSearchPipelineOperations;
    final OpenSearchSnapshotOperations openSearchSnapshotOperations;
    final OpenSearchTaskOperations openSearchTaskOperations;
    final OpenSearchTemplateOperations openSearchTemplateOperations;
    final OpenSearchISMOperations openSearchISMOperations;
    BeanFactory beanFactory;
    OpenSearchClient openSearchClient;

    public RichOpenSearchClient(BeanFactory beanFactory, OpenSearchClient openSearchClient, OpenSearchAsyncClient openSearchAsyncClient, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        this.beanFactory = beanFactory;
        this.openSearchClient = openSearchClient;
        this.async = new Async(this, openSearchAsyncClient);
        this.openSearchBatchOperations = new OpenSearchBatchOperations(LOGGER, openSearchClient, beanFactory);
        this.openSearchClusterOperations = new OpenSearchClusterOperations(LOGGER, openSearchClient);
        this.openSearchDocumentOperations = new OpenSearchDocumentOperations(LOGGER, openSearchClient);
        this.openSearchIndexOperations = new OpenSearchIndexOperations(LOGGER, openSearchClient, objectMapper);
        this.openSearchPipelineOperations = new OpenSearchPipelineOperations(LOGGER, openSearchClient);
        this.openSearchSnapshotOperations = new OpenSearchSnapshotOperations(LOGGER, openSearchClient);
        this.openSearchTaskOperations = new OpenSearchTaskOperations(LOGGER, openSearchClient);
        this.openSearchTemplateOperations = new OpenSearchTemplateOperations(LOGGER, openSearchClient);
        this.openSearchISMOperations = new OpenSearchISMOperations(LOGGER, openSearchClient);
    }

    public Async async() {
        return this.async;
    }

    public OpenSearchBatchOperations batch() {
        return this.openSearchBatchOperations;
    }

    public OpenSearchClusterOperations cluster() {
        return this.openSearchClusterOperations;
    }

    public OpenSearchDocumentOperations doc() {
        return this.openSearchDocumentOperations;
    }

    public OpenSearchIndexOperations index() {
        return this.openSearchIndexOperations;
    }

    public OpenSearchISMOperations ism() {
        return this.openSearchISMOperations;
    }

    public OpenSearchPipelineOperations pipeline() {
        return this.openSearchPipelineOperations;
    }

    public OpenSearchSnapshotOperations snapshot() {
        return this.openSearchSnapshotOperations;
    }

    public OpenSearchTaskOperations task() {
        return this.openSearchTaskOperations;
    }

    public OpenSearchTemplateOperations template() {
        return this.openSearchTemplateOperations;
    }

    public class Async {
        final OpenSearchAsyncDocumentOperations openSearchAsyncDocumentOperations;
        final OpenSearchAsyncIndexOperations openSearchAsyncIndexOperations;
        final OpenSearchAsyncSnapshotOperations openSearchAsyncSnapshotOperations;
        final OpenSearchAsyncTaskOperations openSearchAsyncTaskOperations;

        public Async(RichOpenSearchClient this$0, OpenSearchAsyncClient openSearchAsyncClient) {
            this.openSearchAsyncDocumentOperations = new OpenSearchAsyncDocumentOperations(LOGGER, openSearchAsyncClient);
            this.openSearchAsyncIndexOperations = new OpenSearchAsyncIndexOperations(LOGGER, openSearchAsyncClient);
            this.openSearchAsyncSnapshotOperations = new OpenSearchAsyncSnapshotOperations(LOGGER, openSearchAsyncClient);
            this.openSearchAsyncTaskOperations = new OpenSearchAsyncTaskOperations(LOGGER, openSearchAsyncClient);
        }

        public OpenSearchAsyncDocumentOperations doc() {
            return this.openSearchAsyncDocumentOperations;
        }

        public OpenSearchAsyncIndexOperations index() {
            return this.openSearchAsyncIndexOperations;
        }

        public OpenSearchAsyncSnapshotOperations snapshot() {
            return this.openSearchAsyncSnapshotOperations;
        }

        public OpenSearchAsyncTaskOperations task() {
            return this.openSearchAsyncTaskOperations;
        }
    }

    public record AggregationValue(String key, long count) {
    }
}

