/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import io.camunda.operate.store.opensearch.client.sync.OpenSearchRetryOperation;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.cluster.ComponentTemplate;
import org.opensearch.client.opensearch.cluster.ComponentTemplateNode;
import org.opensearch.client.opensearch.cluster.PutComponentTemplateRequest;
import org.opensearch.client.opensearch.indices.PutIndexTemplateRequest;
import org.slf4j.Logger;

public class OpenSearchTemplateOperations
extends OpenSearchRetryOperation {
    public OpenSearchTemplateOperations(Logger logger, OpenSearchClient openSearchClient) {
        super(logger, openSearchClient);
    }

    private boolean templatesExist(String templatePattern) throws IOException {
        return this.openSearchClient.indices().existsIndexTemplate(it -> it.name(templatePattern)).value();
    }

    public boolean createTemplateWithRetries(PutIndexTemplateRequest request, boolean overwrite) {
        return (Boolean)this.executeWithRetries("CreateTemplate " + request.name(), () -> {
            if (overwrite || !this.templatesExist(request.name())) {
                return this.openSearchClient.indices().putIndexTemplate(request).acknowledged();
            }
            return true;
        });
    }

    public boolean deleteTemplatesWithRetries(String templateNamePattern) {
        return (Boolean)this.executeWithRetries("DeleteTemplate " + templateNamePattern, () -> {
            if (this.templatesExist(templateNamePattern)) {
                return this.openSearchClient.indices().deleteIndexTemplate(it -> it.name(templateNamePattern)).acknowledged();
            }
            return true;
        });
    }

    public boolean createComponentTemplateWithRetries(PutComponentTemplateRequest request) {
        return (Boolean)this.executeWithRetries("CreateComponentTemplate " + request.name(), () -> {
            if (!this.templatesExist(request.name())) {
                return this.openSearchClient.cluster().putComponentTemplate(request).acknowledged();
            }
            return false;
        });
    }

    public Map<String, ComponentTemplateNode> getComponentTemplate() {
        return this.safe(() -> this.openSearchClient.cluster().getComponentTemplate().componentTemplates().stream().collect(Collectors.toMap(ComponentTemplate::name, ComponentTemplate::componentTemplate)), e -> "Failed to get component template from opensearch!");
    }
}

