/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchRetryOperation;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jsonb.JsonbJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.ingest.Processor;
import org.slf4j.Logger;

public class OpenSearchPipelineOperations
extends OpenSearchRetryOperation {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public OpenSearchPipelineOperations(Logger logger, OpenSearchClient openSearchClient) {
        super(logger, openSearchClient);
    }

    public boolean addPipelineWithRetries(String name, String definition) {
        try {
            JsonNode processorsJSONNodes = this.objectMapper.readTree((Reader)new StringReader(definition)).get("processors");
            ArrayList<Processor> processors = new ArrayList<Processor>();
            for (int i = 0; i < processorsJSONNodes.size(); ++i) {
                String processorAsJSON = processorsJSONNodes.get(i).toPrettyString();
                processors.add(this.readProcessorFromJSON(processorAsJSON));
            }
            return (Boolean)this.executeWithRetries("AddPipeline " + name, () -> this.openSearchClient.ingest().putPipeline(p -> p.id(name).processors(processors)).acknowledged());
        }
        catch (Exception e) {
            this.logger.error(String.format("Could not add pipeline %s ", name), (Throwable)e);
            return false;
        }
    }

    private Processor readProcessorFromJSON(String processorText) {
        try (JsonParser jsonParser = JsonProvider.provider().createParser((Reader)new StringReader(processorText));){
            Processor processor = (Processor)Processor._DESERIALIZER.deserialize(jsonParser, (JsonpMapper)new JsonbJsonpMapper());
            return processor;
        }
    }

    public void removePipelineWithRetries(String name) {
        this.executeWithRetries("RemovePipeline " + name, () -> this.openSearchClient.ingest().deletePipeline(dp -> dp.id(name)).acknowledged());
    }
}

