/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.store.ZeebeStore;
import java.io.IOException;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.indices.RefreshResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchZeebeStore
implements ZeebeStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchZeebeStore.class);
    @Autowired
    @Qualifier(value="zeebeOpensearchClient")
    private OpenSearchClient openSearchClient;

    @Override
    public void refreshIndex(String indexPattern) {
        try {
            RefreshResponse response = this.openSearchClient.indices().refresh(r -> r.index(indexPattern, new String[0]));
            if (!response.shards().failures().isEmpty()) {
                LOGGER.warn("Unable to refresh indices: {}", (Object)indexPattern);
            }
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("Unable to refresh indices: %s", indexPattern), (Throwable)ex);
        }
    }

    @Override
    public boolean zeebeIndicesExists(String indexPattern) {
        try {
            boolean exists = this.openSearchClient.indices().exists(r -> r.index(indexPattern, new String[0]).allowNoIndices(Boolean.valueOf(false)).ignoreUnavailable(Boolean.valueOf(true))).value();
            if (exists) {
                LOGGER.debug("Data already exists in Zeebe.");
            }
            return exists;
        }
        catch (IOException io) {
            LOGGER.debug("Error occurred while checking existence of data in Zeebe: {}. Demo data won't be created.", (Object)io.getMessage());
            return false;
        }
    }
}

