/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.store.TaskStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.opensearch.tasks.Info;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpensearchCondition.class})
public class OpensearchTaskStore
implements TaskStore {
    String descriptionPrefixFromIndex = "reindex from [";
    String descriptionPrefixToIndex = "to [";
    String taskActionIndicesReindex = "indices:data/write/reindex";
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;

    @Override
    public List<String> getRunningReindexTasksIdsFor(String fromIndex, String toIndex) throws IOException {
        if (fromIndex == null || toIndex == null) {
            return List.of();
        }
        Map<String, Info> id2taskInfo = this.richOpenSearchClient.task().tasksWithActions(List.of(this.taskActionIndicesReindex));
        Function<String, Boolean> descriptionContainsReindexFromTo = desc -> desc != null && desc.contains(this.descriptionPrefixFromIndex + fromIndex) && desc.contains(this.descriptionPrefixToIndex + toIndex);
        return id2taskInfo.entrySet().stream().filter(id2TaskInfo -> (Boolean)descriptionContainsReindexFromTo.apply(((Info)id2TaskInfo.getValue()).description())).map(Map.Entry::getKey).toList();
    }
}

