/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.SequenceFlowEntity;
import io.camunda.operate.schema.templates.SequenceFlowTemplate;
import io.camunda.operate.store.SequenceFlowStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import java.util.List;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchSequenceFlowStore
implements SequenceFlowStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchSequenceFlowStore.class);
    @Autowired
    private SequenceFlowTemplate sequenceFlowTemplate;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public List<SequenceFlowEntity> getSequenceFlowsByProcessInstanceKey(Long processInstanceKey) {
        Query query = QueryDSL.constantScore(QueryDSL.term("processInstanceKey", processInstanceKey));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.sequenceFlowTemplate, RequestDSL.QueryType.ALL).query(QueryDSL.withTenantCheck(QueryDSL.constantScore(QueryDSL.term("processInstanceKey", processInstanceKey)))).sort(QueryDSL.sortOptions("activityId", SortOrder.Asc), new SortOptions[0]);
        return this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, SequenceFlowEntity.class);
    }
}

