/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.util.ExceptionHelper;
import java.util.Map;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.util.MissingRequiredPropertyException;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpensearchCondition.class})
@Scope(value="prototype")
public class OpensearchBatchRequest
implements BatchRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchBatchRequest.class);
    private final BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;

    @Override
    public BatchRequest add(String index, OperateEntity entity) throws PersistenceException {
        return this.addWithId(index, entity.getId(), entity);
    }

    @Override
    public BatchRequest addWithId(String index, String id, OperateEntity entity) throws PersistenceException {
        LOGGER.debug("Add index request for index {} id {} and entity {} ", new Object[]{index, id, entity});
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(id)).document((Object)entity))));
        return this;
    }

    @Override
    public BatchRequest addWithRouting(String index, OperateEntity entity, String routing) throws PersistenceException {
        LOGGER.debug("Add index request with routing {} for index {} and entity {} ", new Object[]{routing, index, entity});
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.index(idx -> (ObjectBuilder)((IndexOperation.Builder)((IndexOperation.Builder)idx.index(index)).id(entity.getId())).document((Object)entity).routing(routing))), String.format("Error preparing the query to index [%s] of entity type [%s] with routing", entity.getClass().getName(), entity));
        return this;
    }

    @Override
    public BatchRequest upsert(String index, String id, OperateEntity entity, Map<String, Object> updateFields) throws PersistenceException {
        LOGGER.debug("Add upsert request for index {} id {} entity {} and update fields {}", new Object[]{index, id, entity, updateFields});
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).upsert((Object)entity).document((Object)updateFields))), String.format("Error preparing the query to upsert [%s] of entity type [%s]", entity.getClass().getName(), entity));
        return this;
    }

    @Override
    public BatchRequest upsertWithRouting(String index, String id, OperateEntity entity, Map<String, Object> updateFields, String routing) throws PersistenceException {
        LOGGER.debug("Add upsert request with routing {} for index {} id {} entity {} and update fields {}", new Object[]{routing, index, id, entity, updateFields});
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.update(upd -> (ObjectBuilder)((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).upsert((Object)entity).document((Object)updateFields).routing(routing))), String.format("Error preparing the query to upsert [%s] of entity type [%s] with routing", entity.getClass().getName(), entity));
        return this;
    }

    @Override
    public BatchRequest upsertWithScript(String index, String id, OperateEntity entity, String script, Map<String, Object> parameters) throws PersistenceException {
        LOGGER.debug("Add upsert request with for index {} id {} entity {} and script {} with parameters {} ", new Object[]{index, id, entity, script, parameters});
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).upsert((Object)entity).script(QueryDSL.script(script, parameters)).retryOnConflict(Integer.valueOf(3)))), String.format(String.format("Error preparing the query to upsert [%s] of entity type [%s] with script and routing", entity.getClass().getName(), entity), index, id));
        return this;
    }

    @Override
    public BatchRequest upsertWithScriptAndRouting(String index, String id, OperateEntity entity, String script, Map<String, Object> parameters, String routing) throws PersistenceException {
        LOGGER.debug("Add upsert request with routing {} for index {} id {} entity {} and script {} with parameters {} ", new Object[]{routing, index, id, entity, script, parameters});
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).upsert((Object)entity).script(QueryDSL.script(script, parameters)).routing(routing)).retryOnConflict(Integer.valueOf(3)))), String.format(String.format("Error preparing the query to upsert [%s] of entity type [%s] with script and routing", entity.getClass().getName(), entity), index, id));
        return this;
    }

    @Override
    public BatchRequest update(String index, String id, Map<String, Object> updateFields) throws PersistenceException {
        LOGGER.debug("Add update request for index {} id {} and update fields {}", new Object[]{index, id, updateFields});
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).document((Object)updateFields).retryOnConflict(Integer.valueOf(3)))), String.format("Error preparing the query to update index [%s] document with id [%s]", index, id));
        return this;
    }

    @Override
    public BatchRequest update(String index, String id, OperateEntity entity) throws PersistenceException {
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).document((Object)entity).retryOnConflict(Integer.valueOf(3)))), String.format("Error preparing the query to update index [%s] document with id [%s]", index, id));
        return this;
    }

    @Override
    public BatchRequest updateWithScript(String index, String id, String script, Map<String, Object> parameters) throws PersistenceException {
        LOGGER.debug("Add update with script request for index {} id {} ", (Object)index, (Object)id);
        ExceptionHelper.withPersistenceException(() -> this.bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(id)).script(QueryDSL.script(script, parameters)).retryOnConflict(Integer.valueOf(3)))), String.format("Error preparing the query to update index [%s] document with id [%s]", index, id));
        return this;
    }

    @Override
    public void execute() throws PersistenceException {
        this.execute(false);
    }

    @Override
    public void executeWithRefresh() throws PersistenceException {
        this.execute(true);
    }

    private void execute(Boolean shouldRefresh) throws PersistenceException {
        BulkRequest bulkRequest;
        if (shouldRefresh.booleanValue()) {
            this.bulkRequestBuilder.refresh(Refresh.True);
        }
        try {
            bulkRequest = this.bulkRequestBuilder.build();
        }
        catch (MissingRequiredPropertyException e) {
            if ("Missing required property 'BulkRequest.operations'".equals(e.getMessage())) {
                return;
            }
            throw e;
        }
        LOGGER.debug("Execute batchRequest with {} requests", (Object)bulkRequest.operations().size());
        ExceptionHelper.withPersistenceException(() -> {
            this.richOpenSearchClient.batch().bulk(bulkRequest);
            return null;
        });
    }
}

