/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.indices.IndexDescriptor;
import io.camunda.operate.store.elasticsearch.dao.Query;
import io.camunda.operate.store.elasticsearch.dao.response.AggregationResponse;
import io.camunda.operate.store.elasticsearch.dao.response.InsertResponse;
import io.camunda.operate.store.elasticsearch.dao.response.SearchResponse;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericDAO<T extends OperateEntity, I extends IndexDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericDAO.class);
    private RestHighLevelClient esClient;
    private ObjectMapper objectMapper;
    private I index;
    private Class<T> typeOfEntity;

    private GenericDAO() {
    }

    GenericDAO(ObjectMapper objectMapper, I index, RestHighLevelClient esClient) {
        if (objectMapper == null) {
            throw new IllegalStateException("ObjectMapper can't be null");
        }
        if (index == null) {
            throw new IllegalStateException("Index can't be null");
        }
        if (esClient == null) {
            throw new IllegalStateException("ES Client can't be null");
        }
        this.objectMapper = objectMapper;
        this.index = index;
        this.esClient = esClient;
        this.typeOfEntity = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public IndexRequest buildESIndexRequest(T entity) {
        try {
            return new IndexRequest(this.index.getFullQualifiedName()).id(((OperateEntity)entity).getId()).source(this.objectMapper.writeValueAsString(entity), XContentType.JSON);
        }
        catch (JsonProcessingException e) {
            throw new OperateRuntimeException("error building Index/InserRequest");
        }
    }

    public InsertResponse insert(T entity) {
        try {
            IndexRequest request = this.buildESIndexRequest(entity);
            IndexResponse response = this.esClient.index(request, RequestOptions.DEFAULT);
            if (response.status() != RestStatus.CREATED) {
                return InsertResponse.failure();
            }
            return InsertResponse.success();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new OperateRuntimeException("Error while trying to upsert entity: " + String.valueOf(entity));
        }
    }

    public SearchResponse<T> search(Query query) {
        SearchSourceBuilder source = SearchSourceBuilder.searchSource().query(query.getQueryBuilder()).aggregation(query.getAggregationBuilder());
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index.getFullQualifiedName()}).indicesOptions(IndicesOptions.lenientExpandOpen()).source(source);
        try {
            List<T> hits = ElasticsearchUtil.scroll(searchRequest, this.typeOfEntity, this.objectMapper, this.esClient);
            return new SearchResponse<T>(false, hits);
        }
        catch (IOException e) {
            LOGGER.error("Error searching at index: " + String.valueOf(this.index), (Throwable)e);
            return new SearchResponse(true);
        }
    }

    public AggregationResponse searchWithAggregation(Query query) {
        SearchSourceBuilder source = SearchSourceBuilder.searchSource().query(query.getQueryBuilder()).aggregation(query.getAggregationBuilder());
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index.getFullQualifiedName()}).indicesOptions(IndicesOptions.lenientExpandOpen()).source(source);
        try {
            Aggregations aggregations = this.esClient.search(searchRequest, RequestOptions.DEFAULT).getAggregations();
            if (aggregations == null) {
                throw new OperateRuntimeException("Search with aggregation returned no aggregation");
            }
            Aggregation group = aggregations.get(query.getGroupName());
            if (!(group instanceof ParsedStringTerms)) {
                throw new OperateRuntimeException("Unexpected response for aggregations");
            }
            ParsedStringTerms terms = (ParsedStringTerms)group;
            List buckets = terms.getBuckets();
            List<AggregationResponse.AggregationValue> values = buckets.stream().map(it -> new AggregationResponse.AggregationValue(String.valueOf(it.getKey()), it.getDocCount())).collect(Collectors.toList());
            long sumOfOtherDocCounts = ((ParsedStringTerms)group).getSumOfOtherDocCounts();
            long total = sumOfOtherDocCounts + (long)values.size();
            return new AggregationResponse(false, values, total);
        }
        catch (IOException e) {
            LOGGER.error("Error searching at index: " + String.valueOf(this.index), (Throwable)e);
            return new AggregationResponse(true);
        }
    }

    public static class Builder<T extends OperateEntity, I extends IndexDescriptor> {
        private ObjectMapper objectMapper;
        private RestHighLevelClient esClient;
        private I index;

        public Builder<T, I> objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder<T, I> index(I index) {
            this.index = index;
            return this;
        }

        public Builder<T, I> esClient(RestHighLevelClient esClient) {
            this.esClient = esClient;
            return this;
        }

        public GenericDAO<T, I> build() {
            if (this.objectMapper == null) {
                throw new IllegalStateException("ObjectMapper can't be null");
            }
            if (this.index == null) {
                throw new IllegalStateException("Index can't be null");
            }
            if (this.esClient == null) {
                throw new IllegalStateException("ES Client can't be null");
            }
            return new GenericDAO(this.objectMapper, this.index, this.esClient);
        }
    }
}

