/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.UserEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.indices.UserIndex;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.store.UserStore;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
@DependsOn(value={"schemaStartup"})
@Profile(value={"!ldap-auth & !sso-auth & !identity-auth"})
public class ElasticsearchUserStore
implements UserStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchUserStore.class);
    private static final XContentType XCONTENT_TYPE = XContentType.JSON;
    @Autowired
    protected RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    protected ObjectMapper objectMapper;
    @Autowired
    private UserIndex userIndex;

    protected String userEntityToJSONString(UserEntity aUser) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)aUser);
    }

    @Override
    public UserEntity getById(String id) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.userIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"userId", (String)id)));
        try {
            SearchResponse response = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            if (response.getHits().getTotalHits().value == 1L) {
                return ElasticsearchUtil.fromSearchHit(response.getHits().getHits()[0].getSourceAsString(), this.objectMapper, UserEntity.class);
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Could not find unique user with userId '%s'.", id));
            }
            throw new NotFoundException(String.format("Could not find user with userId '%s'.", id));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the user: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public void save(UserEntity user) {
        try {
            IndexRequest request = new IndexRequest(this.userIndex.getFullQualifiedName()).id(user.getId()).source(this.userEntityToJSONString(user), XCONTENT_TYPE);
            this.esClient.index(request, RequestOptions.DEFAULT);
        }
        catch (Exception t) {
            LOGGER.error("Could not create user with userId {}", (Object)user.getUserId(), (Object)t);
        }
    }
}

