/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.FlowNodeStore;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.util.ThreadUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchFlowNodeStore
implements FlowNodeStore {
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private FlowNodeInstanceTemplate flowNodeInstanceTemplate;
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public String getFlowNodeIdByFlowNodeInstanceId(String flowNodeInstanceId) {
        ElasticsearchUtil.QueryType queryType = this.operateProperties.getImporter().isReadArchivedParents() ? ElasticsearchUtil.QueryType.ALL : ElasticsearchUtil.QueryType.ONLY_RUNTIME;
        QueryBuilder query = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"joinRelation", (String)"activity"), QueryBuilders.termQuery((String)"id", (String)flowNodeInstanceId)});
        SearchRequest request = ElasticsearchUtil.createSearchRequest(this.listViewTemplate, queryType).source(new SearchSourceBuilder().query(query).fetchSource("activityId", null));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value != 1L) {
                throw new OperateRuntimeException("Flow node instance is not found: " + flowNodeInstanceId);
            }
            return String.valueOf(response.getHits().getAt(0).getSourceAsMap().get("activityId"));
        }
        catch (IOException e) {
            throw new OperateRuntimeException("Error occurred when searching for flow node instance: " + flowNodeInstanceId, (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getFlowNodeIdsForFlowNodeInstances(Set<String> flowNodeInstanceIds) {
        HashMap<String, String> flowNodeIdsMap = new HashMap<String, String>();
        TermsQueryBuilder q = QueryBuilders.termsQuery((String)"id", flowNodeInstanceIds);
        SearchRequest request = ElasticsearchUtil.createSearchRequest(this.flowNodeInstanceTemplate, ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query((QueryBuilder)q).fetchSource(new String[]{"id", "flowNodeId"}, null));
        try {
            this.tenantAwareClient.search(request, () -> {
                ElasticsearchUtil.scrollWith(request, this.esClient, searchHits -> Arrays.stream(searchHits.getHits()).forEach(h -> flowNodeIdsMap.put(h.getId(), (String)h.getSourceAsMap().get("flowNodeId"))), null, null);
                return null;
            });
        }
        catch (IOException e) {
            throw new OperateRuntimeException("Exception occurred when searching for flow node ids: " + e.getMessage(), (Throwable)e);
        }
        return flowNodeIdsMap;
    }

    @Override
    public String findParentTreePathFor(long parentFlowNodeInstanceKey) {
        return this.findParentTreePath(parentFlowNodeInstanceKey, 0);
    }

    private String findParentTreePath(long parentFlowNodeInstanceKey, int attemptCount) {
        ElasticsearchUtil.QueryType queryType = this.operateProperties.getImporter().isReadArchivedParents() ? ElasticsearchUtil.QueryType.ALL : ElasticsearchUtil.QueryType.ONLY_RUNTIME;
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.flowNodeInstanceTemplate, queryType).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (long)parentFlowNodeInstanceKey)).fetchSource("treePath", null));
        try {
            SearchHits hits = this.tenantAwareClient.search(searchRequest).getHits();
            if (hits.getTotalHits().value > 0L) {
                return (String)hits.getHits()[0].getSourceAsMap().get("treePath");
            }
            if (attemptCount < 1 && this.operateProperties.getImporter().isRetryReadingParents()) {
                ThreadUtil.sleepFor((long)2000L);
                return this.findParentTreePath(parentFlowNodeInstanceKey, attemptCount + 1);
            }
            return null;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while searching for parent flow node instance processes: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }
}

