/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.indices.MigrationRepositoryIndex;
import io.camunda.operate.schema.migration.BaseStepsRepository;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.schema.migration.StepsRepository;
import io.camunda.operate.store.elasticsearch.RetryElasticsearchClient;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchStepsRepository
extends BaseStepsRepository
implements StepsRepository {
    private static final String STEP_FILE_EXTENSION = ".json";
    private static final String DEFAULT_SCHEMA_CHANGE_FOLDER = "/schema/elasticsearch/change";
    private final RetryElasticsearchClient retryElasticsearchClient;
    private final ObjectMapper objectMapper;
    private final OperateProperties operateProperties;
    private final MigrationRepositoryIndex migrationRepositoryIndex;

    @Autowired
    public ElasticsearchStepsRepository(OperateProperties operateProperties, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper, RetryElasticsearchClient retryElasticsearchClient, MigrationRepositoryIndex migrationRepositoryIndex) {
        this.operateProperties = operateProperties;
        this.objectMapper = objectMapper;
        this.retryElasticsearchClient = retryElasticsearchClient;
        this.migrationRepositoryIndex = migrationRepositoryIndex;
    }

    private Step readStepFromFile(InputStream is) throws IOException {
        return (Step)this.objectMapper.readValue(is, Step.class);
    }

    protected String idFromStep(Step step) {
        return step.getVersion() + "-" + step.getOrder();
    }

    @Override
    public void save(Step step) throws MigrationException, IOException {
        boolean createdOrUpdated = this.retryElasticsearchClient.createOrUpdateDocument(this.getName(), this.idFromStep(step), this.objectMapper.writeValueAsString((Object)step));
        if (!createdOrUpdated) {
            throw new MigrationException(String.format("Error in save step %s:  document wasn't created/updated.", step));
        }
        this.logger.info("Step {}  saved.", (Object)step);
    }

    @Override
    public List<Step> findAll() {
        this.logger.debug("Find all steps from Elasticsearch at {}", (Object)this.operateProperties.getElasticsearch().getUrl());
        return this.findBy(Optional.empty());
    }

    @Override
    public List<Step> findNotAppliedFor(String indexName) {
        this.logger.debug("Find 'not applied steps' for index {} from Elasticsearch at {} ", (Object)indexName, (Object)this.operateProperties.getElasticsearch().getUrl());
        return this.findBy(Optional.ofNullable(ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"indexName.keyword", (String)indexName), QueryBuilders.termQuery((String)"applied", (boolean)false)})));
    }

    @Override
    public String getName() {
        return this.migrationRepositoryIndex.getFullQualifiedName();
    }

    @Override
    public void refreshIndex() {
        this.retryElasticsearchClient.refresh(this.getName());
    }

    @Override
    public List<Step> readStepsFromClasspath() throws IOException {
        ArrayList<Step> steps = new ArrayList<Step>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("/schema/elasticsearch/change/*.json")) {
                this.logger.info("Read step {} ", (Object)resource.getFilename());
                steps.add(this.readStepFromFile(resource.getInputStream()));
            }
            steps.sort(Step.SEMANTICVERSION_ORDER_COMPARATOR);
            return steps;
        }
        catch (FileNotFoundException ex) {
            this.logger.warn("Directory with migration steps was not found: " + ex.getMessage());
            return steps;
        }
    }

    protected List<Step> findBy(Optional<QueryBuilder> query) {
        SearchSourceBuilder searchSpec = new SearchSourceBuilder().sort("version.keyword", SortOrder.ASC);
        query.ifPresent(arg_0 -> ((SearchSourceBuilder)searchSpec).query(arg_0));
        SearchRequest request = new SearchRequest(new String[]{this.getName()}).source(searchSpec).indicesOptions(IndicesOptions.lenientExpandOpen());
        return this.retryElasticsearchClient.searchWithScroll(request, Step.class, this.objectMapper);
    }
}

