/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.migration.ReindexWithQueryAndScriptPlan;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.store.elasticsearch.RetryElasticsearchClient;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.util.LambdaExceptionUtil;
import io.camunda.operate.util.Tuple;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ElasticsearchReindexWithQueryAndScriptPlan
implements ReindexWithQueryAndScriptPlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchReindexWithQueryAndScriptPlan.class);
    private List<Step> steps = List.of();
    private String srcIndex;
    private String dstIndex;
    private final MigrationProperties migrationProperties;
    private String listViewIndexName;
    private final ObjectMapper objectMapper;
    private final RestHighLevelClient esClient;
    private final RetryElasticsearchClient retryElasticsearchClient;

    public ElasticsearchReindexWithQueryAndScriptPlan(MigrationProperties migrationProperties, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper, RestHighLevelClient esClient, RetryElasticsearchClient retryElasticsearchClient) {
        this.migrationProperties = migrationProperties;
        this.objectMapper = objectMapper;
        this.esClient = esClient;
        this.retryElasticsearchClient = retryElasticsearchClient;
    }

    @Override
    public ReindexWithQueryAndScriptPlan setSrcIndex(String srcIndex) {
        this.srcIndex = srcIndex;
        return this;
    }

    @Override
    public ReindexWithQueryAndScriptPlan setDstIndex(String dstIndex) {
        this.dstIndex = dstIndex;
        return this;
    }

    @Override
    public ReindexWithQueryAndScriptPlan setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    @Override
    public ReindexWithQueryAndScriptPlan setListViewIndexName(String listViewIndexName) {
        this.listViewIndexName = listViewIndexName;
        return this;
    }

    private Script buildScript(String scriptContent, Map<String, Tuple<String, String>> bpmnProcessIdsMap) throws JsonProcessingException {
        Map<String, Map<String, Tuple<String, String>>> paramsMap = Map.of("dstIndex", this.dstIndex, "bpmnProcessIds", bpmnProcessIdsMap);
        Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(paramsMap), HashMap.class);
        return new Script(ScriptType.INLINE, "painless", scriptContent, jsonMap);
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }

    @Override
    public void executeOn(SchemaManager schemaManager) throws MigrationException {
        String processInstanceKeyField = "processInstanceKey";
        SearchRequest searchRequest = new SearchRequest(new String[]{this.srcIndex + "_*"}).source(new SearchSourceBuilder().fetchField("processInstanceKey").sort("processInstanceKey").size(this.migrationProperties.getScriptParamsCount()));
        HashSet<Long> processInstanceKeys = new HashSet<Long>();
        try {
            ElasticsearchUtil.scroll(searchRequest, LambdaExceptionUtil.rethrowConsumer(hits -> {
                Set currentProcessInstanceKeys = Arrays.stream(hits.getHits()).map(sh -> (Long)sh.getSourceAsMap().get("processInstanceKey")).collect(Collectors.toSet());
                if (processInstanceKeys.size() + currentProcessInstanceKeys.size() >= this.migrationProperties.getScriptParamsCount()) {
                    int remainingSize = this.migrationProperties.getScriptParamsCount() - processInstanceKeys.size();
                    Set subSet = currentProcessInstanceKeys.stream().limit(remainingSize).collect(Collectors.toSet());
                    currentProcessInstanceKeys.removeAll(subSet);
                    processInstanceKeys.addAll(subSet);
                    this.reindexPart(this.esClient, processInstanceKeys);
                    processInstanceKeys.clear();
                    processInstanceKeys.addAll(currentProcessInstanceKeys);
                } else {
                    processInstanceKeys.addAll(currentProcessInstanceKeys);
                }
            }), this.esClient, this.migrationProperties.getScrollKeepAlive());
            if (processInstanceKeys.size() > 0) {
                this.reindexPart(this.esClient, processInstanceKeys);
            }
        }
        catch (Exception e) {
            throw new MigrationException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void validateMigrationResults(SchemaManager schemaManager) throws MigrationException {
        long srcCount = schemaManager.getNumberOfDocumentsFor(this.srcIndex + "_*");
        long dstCount = schemaManager.getNumberOfDocumentsFor(this.dstIndex + "_*");
        if (srcCount != dstCount) {
            throw new MigrationException(String.format("Exception occurred when migrating %s. Number of documents in source indices: %s, number of documents in destination indices: %s", this.srcIndex, srcCount, dstCount));
        }
    }

    private void reindexPart(RestHighLevelClient esClient, Set<Long> processInstanceKeys) throws MigrationException, JsonProcessingException {
        Map<String, Tuple<String, String>> bpmnProcessIdsMap = this.getBpmnProcessIds(processInstanceKeys, esClient);
        LOGGER.debug("Migrate srcIndex: {}, processInstanceKeys: {}, bpmnProcessIdsMap: {}", new Object[]{this.srcIndex, processInstanceKeys, bpmnProcessIdsMap});
        ReindexRequest reindexRequest = ((ReindexRequest)new ReindexRequest().setSourceIndices(new String[]{this.srcIndex + "_*"}).setDestIndex(this.dstIndex + "_").setSlices(this.migrationProperties.getSlices())).setSourceQuery((QueryBuilder)QueryBuilders.termsQuery((String)"processInstanceKey", processInstanceKeys)).setSourceBatchSize(this.migrationProperties.getReindexBatchSize());
        String content = this.steps.get(0).getContent();
        reindexRequest.setScript(this.buildScript("ctx._index = params.dstIndex+'_' + (ctx._index.substring(ctx._index.indexOf('_') + 1, ctx._index.length()));" + content, bpmnProcessIdsMap));
        this.retryElasticsearchClient.reindex(reindexRequest, false);
    }

    private Map<String, Tuple<String, String>> getBpmnProcessIds(Set<Long> processInstanceKeys, RestHighLevelClient esClient) throws MigrationException {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.listViewIndexName + "*"}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termsQuery((String)"key", processInstanceKeys)).fetchSource(new String[]{"key", "bpmnProcessId", "processDefinitionKey"}, null).size(this.migrationProperties.getScriptParamsCount()));
        try {
            HashMap<String, Tuple<String, String>> result = new HashMap<String, Tuple<String, String>>();
            ElasticsearchUtil.scroll(searchRequest, hits -> Arrays.stream(hits.getHits()).forEach(sh -> {
                Map sourceAsMap = sh.getSourceAsMap();
                result.put(String.valueOf(sourceAsMap.get("key")), new Tuple((Object)((String)sourceAsMap.get("bpmnProcessId")), (Object)String.valueOf(sourceAsMap.get("processDefinitionKey"))));
            }), esClient, this.migrationProperties.getScrollKeepAlive());
            return result;
        }
        catch (IOException e) {
            throw new MigrationException(e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return "ElasticsearchReindexWithQueryAndScriptPlan [steps=" + String.valueOf(this.steps) + ",  srcIndex=" + this.srcIndex + ", dstIndex=" + this.dstIndex + "]";
    }
}

