/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.migration.FillPostImporterQueuePlan;
import io.camunda.operate.schema.migration.MigrationPlanFactory;
import io.camunda.operate.schema.migration.ReindexPlan;
import io.camunda.operate.schema.migration.ReindexWithQueryAndScriptPlan;
import io.camunda.operate.schema.migration.elasticsearch.ElasticsearchFillPostImporterQueuePlan;
import io.camunda.operate.schema.migration.elasticsearch.ElasticsearchPipelineReindexPlan;
import io.camunda.operate.schema.migration.elasticsearch.ElasticsearchReindexWithQueryAndScriptPlan;
import io.camunda.operate.store.elasticsearch.RetryElasticsearchClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticsearchCondition.class})
public class ElasticsearchMigrationPlanFactory
implements MigrationPlanFactory {
    private final OperateProperties operateProperties;
    private final MigrationProperties migrationProperties;
    private final ObjectMapper objectMapper;
    private final RetryElasticsearchClient retryElasticsearchClient;
    private final RestHighLevelClient esClient;

    @Autowired
    public ElasticsearchMigrationPlanFactory(OperateProperties operateProperties, MigrationProperties migrationProperties, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper, RetryElasticsearchClient retryElasticsearchClient, RestHighLevelClient esClient) {
        this.operateProperties = operateProperties;
        this.migrationProperties = migrationProperties;
        this.objectMapper = objectMapper;
        this.retryElasticsearchClient = retryElasticsearchClient;
        this.esClient = esClient;
    }

    @Override
    public FillPostImporterQueuePlan createFillPostImporterQueuePlan() {
        return new ElasticsearchFillPostImporterQueuePlan(this.operateProperties, this.migrationProperties, this.objectMapper, this.esClient);
    }

    @Override
    public ReindexPlan createReindexPlan() {
        return new ElasticsearchPipelineReindexPlan(this.retryElasticsearchClient, this.migrationProperties);
    }

    @Override
    public ReindexWithQueryAndScriptPlan createReindexWithQueryAndScriptPlan() {
        return new ElasticsearchReindexWithQueryAndScriptPlan(this.migrationProperties, this.objectMapper, this.esClient, this.retryElasticsearchClient);
    }
}

