/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema;

import io.camunda.operate.conditions.DatabaseInfo;
import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.IndexMapping;
import io.camunda.operate.schema.IndexSchemaValidator;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.indices.IndexDescriptor;
import io.camunda.operate.schema.migration.Migrator;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component(value="schemaStartup")
@DependsOn(value={"databaseInfo"})
@Profile(value={"!test"})
public class SchemaStartup {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaStartup.class);
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private IndexSchemaValidator schemaValidator;
    @Autowired
    private Migrator migrator;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private MigrationProperties migrationProperties;

    @PostConstruct
    public void initializeSchema() throws MigrationException {
        try {
            boolean createSchema;
            LOGGER.info("SchemaStartup started.");
            LOGGER.info("SchemaStartup: validate index versions.");
            this.schemaValidator.validateIndexVersions();
            LOGGER.info("SchemaStartup: validate index mappings.");
            Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields = this.schemaValidator.validateIndexMappings();
            boolean bl = createSchema = DatabaseInfo.isOpensearch() ? this.operateProperties.getOpensearch().isCreateSchema() : this.operateProperties.getElasticsearch().isCreateSchema();
            if (createSchema && !this.schemaValidator.schemaExists()) {
                LOGGER.info("SchemaStartup: schema is empty or not complete. Indices will be created.");
                this.schemaManager.createSchema();
                LOGGER.info("SchemaStartup: update index mappings.");
            } else {
                LOGGER.info("SchemaStartup: schema won't be created, it either already exist, or schema creation is disabled in configuration.");
            }
            if (!newFields.isEmpty()) {
                if (createSchema) {
                    this.schemaManager.updateSchema(newFields);
                } else {
                    LOGGER.info("SchemaStartup: schema won't be updated as schema creation is disabled in configuration.");
                }
            }
            if (this.migrationProperties.isMigrationEnabled()) {
                LOGGER.info("SchemaStartup: migrate schema.");
                this.migrator.migrateData();
            }
            LOGGER.info("SchemaStartup finished.");
        }
        catch (Exception ex) {
            LOGGER.error("Schema startup failed: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }
}

