/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.management;

import io.camunda.operate.Metrics;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.store.DecisionStore;
import io.camunda.operate.store.ProcessStore;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ModelMetricProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProcessStore processStore;
    @Autowired
    private DecisionStore decisionStore;
    @Autowired
    private Metrics metrics;
    @Autowired
    private OperateProperties operateProperties;
    private Long lastBPMNModelCount = 0L;
    private Long lastDMNModelCount = 0L;

    @PostConstruct
    private void registerMetrics() {
        this.logger.info("Register BPMN/DMN model metrics.");
        String organizationId = this.operateProperties.getCloud().getOrganizationId();
        if (StringUtils.hasText((String)organizationId)) {
            this.metrics.registerGaugeSupplier("operate.model.bpmn.count", this::getBPMNModelCount, new String[]{"organizationId", organizationId});
            this.metrics.registerGaugeSupplier("operate.model.dmn.count", this::getDMNModelCount, new String[]{"organizationId", organizationId});
        } else {
            this.metrics.registerGaugeSupplier("operate.model.bpmn.count", this::getBPMNModelCount, new String[0]);
            this.metrics.registerGaugeSupplier("operate.model.dmn.count", this::getDMNModelCount, new String[0]);
        }
    }

    public Long getBPMNModelCount() {
        Optional<Long> optionalCount = this.processStore.getDistinctCountFor("bpmnProcessId");
        optionalCount.ifPresent(val -> {
            this.lastBPMNModelCount = val;
        });
        return this.lastBPMNModelCount;
    }

    public Long getDMNModelCount() {
        Optional<Long> optionalCount = this.decisionStore.getDistinctCountFor("decisionId");
        optionalCount.ifPresent(val -> {
            this.lastDMNModelCount = val;
        });
        return this.lastDMNModelCount;
    }
}

