/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.entities;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ListenerType {
    EXECUTION_LISTENER,
    TASK_LISTENER,
    UNKNOWN;

    private static final Logger LOGGER;

    public static ListenerType fromZeebeJobKind(String jobKind) {
        if (jobKind == null) {
            LOGGER.warn("Job kind is null. UNKNOWN type will be assigned.", (Object)jobKind);
            return UNKNOWN;
        }
        try {
            return ListenerType.valueOf(jobKind);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Job kind not found for value [{}]. UNKNOWN type will be assigned.", (Object)jobKind);
            return UNKNOWN;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ListenerType.class);
    }
}

