/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.entities;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EventType {
    CREATED,
    RESOLVED,
    SEQUENCE_FLOW_TAKEN,
    ELEMENT_ACTIVATING,
    ELEMENT_ACTIVATED,
    ELEMENT_COMPLETING,
    ELEMENT_COMPLETED,
    ELEMENT_TERMINATED,
    ACTIVATED,
    COMPLETED,
    TIMED_OUT,
    FAILED,
    RETRIES_UPDATED,
    CORRELATED,
    CANCELED,
    MIGRATED,
    UNKNOWN;

    private static final Logger LOGGER;

    public static EventType fromZeebeIntent(String intent) {
        try {
            return EventType.valueOf(intent);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Event type not found for value [{}]. UNKNOWN type will be assigned.", (Object)intent);
            return UNKNOWN;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(EventType.class);
    }
}

