/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util;

import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationState;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.BatchOperationTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.OperationStore;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperationsManager {
    private final Logger logger;
    private final BeanFactory beanFactory;
    private final BatchOperationTemplate batchOperationTemplate;
    private final OperationTemplate operationTemplate;
    private final OperationStore operationStore;

    public OperationsManager(Logger logger, BeanFactory beanFactory, BatchOperationTemplate batchOperationTemplate, OperationTemplate operationTemplate, OperationStore operationStore) {
        this.logger = logger;
        this.beanFactory = beanFactory;
        this.batchOperationTemplate = batchOperationTemplate;
        this.operationTemplate = operationTemplate;
        this.operationStore = operationStore;
    }

    @Autowired
    public OperationsManager(BeanFactory beanFactory, BatchOperationTemplate batchOperationTemplate, OperationTemplate operationTemplate, OperationStore operationStore) {
        this.logger = LoggerFactory.getLogger(OperationsManager.class);
        this.beanFactory = beanFactory;
        this.batchOperationTemplate = batchOperationTemplate;
        this.operationTemplate = operationTemplate;
        this.operationStore = operationStore;
    }

    public void updateFinishedInBatchOperation(String batchOperationId) throws PersistenceException {
        this.updateFinishedInBatchOperation(batchOperationId, null);
    }

    public void updateFinishedInBatchOperation(String batchOperationId, BatchRequest batchRequest) throws PersistenceException {
        Map<String, String> ids2indexNames = this.getIndexNameForAliasAndId(this.batchOperationTemplate.getAlias(), batchOperationId);
        String index = ids2indexNames.get(batchOperationId);
        if (this.isIndexEmptyFor(index, batchOperationId)) {
            return;
        }
        String script = "ctx._source.operationsFinishedCount += 1;if (ctx._source.operationsFinishedCount == ctx._source.operationsTotalCount)    ctx._source.endDate = params.now;";
        Map<String, Object> parameters = Map.of("now", OffsetDateTime.now());
        if (batchRequest == null) {
            this.operationStore.updateWithScript(index, batchOperationId, "ctx._source.operationsFinishedCount += 1;if (ctx._source.operationsFinishedCount == ctx._source.operationsTotalCount)    ctx._source.endDate = params.now;", parameters);
        } else {
            batchRequest.updateWithScript(index, batchOperationId, "ctx._source.operationsFinishedCount += 1;if (ctx._source.operationsFinishedCount == ctx._source.operationsTotalCount)    ctx._source.endDate = params.now;", parameters);
        }
    }

    public void updateInstancesInBatchOperation(String batchOperationId, long increment) throws PersistenceException {
        this.updateInstancesInBatchOperation(batchOperationId, null, increment);
    }

    public void updateInstancesInBatchOperation(String batchOperationId, BatchRequest batchRequest, long increment) throws PersistenceException {
        Map<String, String> ids2indexNames = this.getIndexNameForAliasAndId(this.batchOperationTemplate.getAlias(), batchOperationId);
        String index = ids2indexNames.get(batchOperationId);
        if (this.isIndexEmptyFor(index, batchOperationId)) {
            return;
        }
        String script = String.format("ctx._source.%s += %d;", "instancesCount", increment);
        Map<String, Object> parameters = Map.of();
        if (batchRequest == null) {
            this.operationStore.updateWithScript(index, batchOperationId, script, parameters);
        } else {
            batchRequest.updateWithScript(index, batchOperationId, script, parameters);
        }
    }

    public void completeOperation(Long zeebeCommandKey, Long processInstanceKey, Long incidentKey, OperationType operationType, BatchRequest batchRequest) throws PersistenceException {
        BatchRequest theBatchRequest = Objects.requireNonNullElseGet(batchRequest, this::newBatchRequest);
        List<OperationEntity> operationEntities = this.getOperations(zeebeCommandKey, processInstanceKey, incidentKey, operationType);
        List<String> operationIds = operationEntities.stream().map(OperateEntity::getId).collect(Collectors.toList());
        Map<String, String> ids2indexNames = this.getIndexNameForAliasAndIds(this.operationTemplate.getAlias(), operationIds);
        for (OperationEntity o : operationEntities) {
            if (o.getBatchOperationId() != null) {
                this.updateFinishedInBatchOperation(o.getBatchOperationId(), theBatchRequest);
            }
            this.completeOperation(ids2indexNames.get(o.getId()), o.getId(), theBatchRequest);
        }
        if (batchRequest == null) {
            theBatchRequest.execute();
        }
    }

    public void completeOperation(OperationEntity operationEntity) throws PersistenceException {
        this.completeOperation(operationEntity, true);
    }

    public void completeOperation(OperationEntity operationEntity, boolean updateFinishedInBatch) throws PersistenceException {
        BatchRequest batchRequest = this.newBatchRequest();
        if (operationEntity.getBatchOperationId() != null && updateFinishedInBatch) {
            this.updateFinishedInBatchOperation(operationEntity.getBatchOperationId(), batchRequest);
        }
        Map<String, String> ids2indexNames = this.getIndexNameForAliasAndId(this.operationTemplate.getAlias(), operationEntity.getId());
        this.completeOperation(ids2indexNames.get(operationEntity.getId()), operationEntity.getId(), batchRequest);
        batchRequest.execute();
    }

    private BatchRequest newBatchRequest() {
        return (BatchRequest)this.beanFactory.getBean(BatchRequest.class);
    }

    private List<OperationEntity> getOperations(Long zeebeCommandKey, Long processInstanceKey, Long incidentKey, OperationType operationType) {
        return this.operationStore.getOperationsFor(zeebeCommandKey, processInstanceKey, incidentKey, operationType);
    }

    private void completeOperation(String indexName, String operationId, BatchRequest batchRequest) throws PersistenceException {
        String script = "ctx._source.state = '" + String.valueOf((Object)OperationState.COMPLETED) + "';ctx._source.lockOwner = null;ctx._source.lockExpirationTime = null;ctx._source.completedDate = params.now;";
        batchRequest.updateWithScript(indexName, operationId, script, Map.of("now", OffsetDateTime.now()));
    }

    private Map<String, String> getIndexNameForAliasAndId(String alias, String id) {
        return this.getIndexNameForAliasAndIds(alias, List.of(id));
    }

    private Map<String, String> getIndexNameForAliasAndIds(String alias, Collection<String> ids) {
        return this.operationStore.getIndexNameForAliasAndIds(alias, ids);
    }

    private boolean isIndexEmptyFor(String index, String batchOperationId) {
        if (index == null || index.isEmpty()) {
            this.logger.warn("No index found for batchOperationId={}. Skip adding an update request.", (Object)batchOperationId);
            return true;
        }
        return false;
    }
}

