/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.util.ExceptionSupplier;
import java.io.IOException;
import java.util.function.Supplier;
import org.opensearch.client.opensearch._types.OpenSearchException;

public interface ExceptionHelper {
    public static <R> R withPersistenceException(Supplier<R> supplier) throws PersistenceException {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage(), e.getCause());
        }
    }

    public static <R> R withPersistenceException(Supplier<R> supplier, String errorMessage) throws PersistenceException {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new PersistenceException(errorMessage, (Throwable)e);
        }
    }

    public static <R> R withOperateRuntimeException(ExceptionSupplier<R> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new OperateRuntimeException(e.getMessage(), e.getCause());
        }
    }

    public static <R> R withIOException(ExceptionSupplier<R> supplier) throws IOException {
        try {
            return supplier.get();
        }
        catch (OpenSearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e.getCause());
        }
    }
}

