/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchSyncOperation;
import io.camunda.operate.store.opensearch.response.OpenSearchGetSnapshotResponse;
import io.camunda.operate.store.opensearch.response.OpenSearchSnapshotInfo;
import io.camunda.operate.store.opensearch.response.SnapshotState;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.snapshot.GetRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.GetSnapshotRequest;
import org.slf4j.Logger;

public class OpenSearchSnapshotOperations
extends OpenSearchSyncOperation {
    public OpenSearchSnapshotOperations(Logger logger, OpenSearchClient openSearchClient) {
        super(logger, openSearchClient);
    }

    public Map<String, Object> getRepository(GetRepositoryRequest.Builder requestBuilder) {
        GetRepositoryRequest request = requestBuilder.build();
        List names = request.name();
        if (names.isEmpty()) {
            throw new OperateRuntimeException("Get repository needs at least one name.");
        }
        if (names.size() > 1) {
            this.logger.warn("More than one repository names given: {} . Use only first one: {}", (Object)names, names.getFirst());
        }
        String repository = (String)names.getFirst();
        return this.withExtendedOpenSearchClient(extendedOpenSearchClient -> this.safe(() -> extendedOpenSearchClient.arbitraryRequest("GET", String.format("/_snapshot/%s", repository), "{}"), e -> String.format("Failed to get repository %s", repository)));
    }

    public OpenSearchGetSnapshotResponse get(GetSnapshotRequest.Builder requestBuilder) {
        GetSnapshotRequest request = requestBuilder.build();
        String repository = request.repository();
        List snapshots = request.snapshot();
        if (snapshots.size() > 1) {
            this.logger.warn("More than one snapshot names given: {} . Use only first one: {}", (Object)snapshots, snapshots.getFirst());
        }
        String snapshot = (String)snapshots.getFirst();
        Map result = this.withExtendedOpenSearchClient(extendedOpenSearchClient -> this.safe(() -> extendedOpenSearchClient.arbitraryRequest("GET", String.format("/_snapshot/%s/%s", repository, snapshot), "{}"), e -> String.format("Failed to get snapshot %s in repository %s", snapshot, repository)));
        List snapshotInfosAsMap = (List)result.get("snapshots");
        List<OpenSearchSnapshotInfo> snapshotInfos = snapshotInfosAsMap.stream().map(this::mapToSnapshotInfo).toList();
        return new OpenSearchGetSnapshotResponse(snapshotInfos);
    }

    private OpenSearchSnapshotInfo mapToSnapshotInfo(Map<String, Object> map) {
        Map metadata = (Map)map.get("metadata");
        List failures = (List)map.get("failures");
        return new OpenSearchSnapshotInfo().setSnapshot((String)map.get("snapshot")).setUuid((String)map.get("uuid")).setState(SnapshotState.valueOf((String)map.get("state"))).setStartTimeInMillis((Long)map.get("start_time_in_millis")).setMetadata(metadata).setFailures(failures);
    }
}

