/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import io.camunda.operate.store.opensearch.client.sync.OpenSearchSyncOperation;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.HealthStatus;
import org.opensearch.client.opensearch.cluster.HealthResponse;
import org.opensearch.client.opensearch.nodes.Stats;
import org.slf4j.Logger;

public class OpenSearchClusterOperations
extends OpenSearchSyncOperation {
    public OpenSearchClusterOperations(Logger logger, OpenSearchClient openSearchClient) {
        super(logger, openSearchClient);
    }

    public boolean isHealthy() {
        try {
            HealthResponse response = this.openSearchClient.cluster().health(h -> h.timeout(t -> t.time("5s")));
            HealthStatus status = response.status();
            return !response.timedOut() && !status.equals((Object)HealthStatus.Red);
        }
        catch (IOException e) {
            this.logger.error(String.format("Couldn't connect to OpenSearch due to %s. Return unhealthy state.", e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public Map<String, Stats> nodesStats() throws IOException {
        return this.openSearchClient.nodes().stats().nodes();
    }

    public int totalOpenContexts() throws IOException {
        return this.openContexts().values().stream().mapToInt(Long::intValue).sum();
    }

    public Map<String, Long> openContexts() throws IOException {
        return this.nodesStats().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Stats)entry.getValue()).indices().search().openContexts()));
    }
}

