/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.OperateZeebeEntity;
import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.indices.ProcessIndex;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.schema.templates.ProcessInstanceDependant;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.FiltersBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchProcessStore
implements ProcessStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchProcessStore.class);
    private static final String DISTINCT_FIELD_COUNTS = "distinctFieldCounts";
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private List<ProcessInstanceDependant> processInstanceDependantTemplates;

    @Override
    public Optional<Long> getDistinctCountFor(String fieldName) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.processIndex.getAlias()).query(QueryDSL.matchAll()).aggregations(DISTINCT_FIELD_COUNTS, AggregationDSL.cardinalityAggregation(fieldName, 1000)._toAggregation()).size(Integer.valueOf(0));
        try {
            SearchResponse<Void> response = this.richOpenSearchClient.doc().search(searchRequestBuilder, Void.class);
            return Optional.of(((Aggregate)response.aggregations().get(DISTINCT_FIELD_COUNTS)).cardinality().value());
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error in distinct count for field %s in index alias %s.", fieldName, this.processIndex.getAlias()), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void refreshIndices(String ... indices) {
        this.richOpenSearchClient.index().refresh(indices);
    }

    @Override
    public ProcessEntity getProcessByKey(Long processDefinitionKey) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.processIndex.getAlias()).query(QueryDSL.withTenantCheck(QueryDSL.term("key", processDefinitionKey)));
        return this.richOpenSearchClient.doc().searchUnique(searchRequestBuilder, ProcessEntity.class, String.valueOf(processDefinitionKey));
    }

    @Override
    public String getDiagramByKey(Long processDefinitionKey) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.processIndex.getAlias()).query(QueryDSL.withTenantCheck(QueryDSL.ids(processDefinitionKey.toString())));
        return this.richOpenSearchClient.doc().searchUnique(searchRequestBuilder, ProcessEntity.class, processDefinitionKey.toString()).getBpmnXml();
    }

    @Override
    public Map<ProcessStore.ProcessKey, List<ProcessEntity>> getProcessesGrouped(String tenantId, Set<String> allowedBPMNProcessIds) {
        String tenantsGroupsAggName = "group_by_tenantId";
        String groupsAggName = "group_by_bpmnProcessId";
        String processesAggName = "processes";
        List<String> sourceFields = List.of("id", "name", "version", "versionTag", "bpmnProcessId", "tenantId");
        Query query = allowedBPMNProcessIds == null ? QueryDSL.matchAll() : QueryDSL.stringTerms("bpmnProcessId", allowedBPMNProcessIds);
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.processIndex.getAlias()).query(QueryDSL.withTenantCheck(this.withTenantIdQuery(tenantId, query))).size(Integer.valueOf(0)).aggregations("group_by_tenantId", AggregationDSL.withSubaggregations(AggregationDSL.termAggregation("tenantId", 10000), Map.of("group_by_bpmnProcessId", AggregationDSL.withSubaggregations(AggregationDSL.termAggregation("bpmnProcessId", 10000), Map.of("processes", AggregationDSL.topHitsAggregation(sourceFields, 100, QueryDSL.sortOptions("version", SortOrder.Desc))._toAggregation())))));
        SearchResponse<Object> response = this.richOpenSearchClient.doc().search(searchRequestBuilder, Object.class);
        HashMap<ProcessStore.ProcessKey, List<ProcessEntity>> result = new HashMap<ProcessStore.ProcessKey, List<ProcessEntity>>();
        ((Aggregate)response.aggregations().get("group_by_tenantId")).sterms().buckets().array().forEach(tenantBucket -> ((Aggregate)tenantBucket.aggregations().get("group_by_bpmnProcessId")).sterms().buckets().array().forEach(bpmnProcessIdBucket -> {
            String key = tenantBucket.key() + "_" + bpmnProcessIdBucket.key();
            List<ProcessEntity> value = ((Aggregate)bpmnProcessIdBucket.aggregations().get("processes")).topHits().hits().hits().stream().map(h -> (ProcessEntity)((JsonData)h.source()).to(ProcessEntity.class)).toList();
            result.put(new ProcessStore.ProcessKey(key, tenantId), value);
        }));
        return result;
    }

    @Override
    public Map<Long, ProcessEntity> getProcessesIdsToProcessesWithFields(Set<String> allowedBPMNIds, int maxSize, String ... fields) {
        Query query = allowedBPMNIds == null ? QueryDSL.matchAll() : QueryDSL.stringTerms("bpmnProcessId", allowedBPMNIds);
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.processIndex.getAlias()).query(QueryDSL.withTenantCheck(query)).source(QueryDSL.sourceInclude(fields)).size(Integer.valueOf(maxSize));
        return this.richOpenSearchClient.doc().searchValues(searchRequestBuilder, ProcessEntity.class).stream().collect(Collectors.toMap(OperateZeebeEntity::getKey, UnaryOperator.identity()));
    }

    @Override
    public long deleteProcessDefinitionsByKeys(Long ... processDefinitionKeys) {
        if (CollectionUtil.isEmpty((Object[])processDefinitionKeys)) {
            return 0L;
        }
        return this.richOpenSearchClient.doc().deleteByQuery(this.processIndex.getAlias(), QueryDSL.longTerms("key", List.of(processDefinitionKeys)));
    }

    @Override
    public ProcessInstanceForListViewEntity getProcessInstanceListViewByKey(Long processInstanceKey) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate, RequestDSL.QueryType.ALL).query(QueryDSL.withTenantCheck(QueryDSL.and(QueryDSL.ids(String.valueOf(processInstanceKey)), QueryDSL.term("processInstanceKey", processInstanceKey))));
        return this.richOpenSearchClient.doc().searchUnique(searchRequestBuilder, ProcessInstanceForListViewEntity.class, String.valueOf(processInstanceKey));
    }

    @Override
    public Map<String, Long> getCoreStatistics(Set<String> allowedBPMNIds) {
        Query incidentsQuery = QueryDSL.and(QueryDSL.term("incident", true), QueryDSL.term("joinRelation", "processInstance"));
        Query runningQuery = QueryDSL.term("state", ProcessInstanceState.ACTIVE.name());
        Query query = allowedBPMNIds == null ? QueryDSL.matchAll() : QueryDSL.stringTerms("bpmnProcessId", allowedBPMNIds);
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate, RequestDSL.QueryType.ALL).query(QueryDSL.withTenantCheck(query)).aggregations("agg", AggregationDSL.filtersAggregation(Map.of("incidents", incidentsQuery, "running", runningQuery))._toAggregation());
        Map buckets = ((Aggregate)this.richOpenSearchClient.doc().search(searchRequestBuilder, Void.class).aggregations().get("agg")).filters().buckets().keyed();
        return Map.of("running", ((FiltersBucket)buckets.get("running")).docCount(), "incidents", ((FiltersBucket)buckets.get("incidents")).docCount());
    }

    @Override
    public String getProcessInstanceTreePathById(String processInstanceId) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate).query(QueryDSL.withTenantCheck(QueryDSL.and(QueryDSL.term("joinRelation", "processInstance"), QueryDSL.term("key", processInstanceId)))).source(QueryDSL.sourceInclude("treePath"));
        record Result(String treePath) {
        }
        return this.richOpenSearchClient.doc().searchUnique(searchRequestBuilder, Result.class, processInstanceId).treePath();
    }

    @Override
    public List<Map<String, String>> createCallHierarchyFor(List<String> processInstanceIds, String currentProcessInstanceId) {
        List<String> processInstanceIdsWithoutCurrentProcess = processInstanceIds.stream().filter(id -> !currentProcessInstanceId.equals(id)).toList();
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate).query(QueryDSL.withTenantCheck(QueryDSL.and(QueryDSL.term("joinRelation", "processInstance"), QueryDSL.stringTerms("id", processInstanceIdsWithoutCurrentProcess)))).source(QueryDSL.sourceInclude("id", "processDefinitionKey", "processName", "bpmnProcessId"));
        record Result(String id, String processDefinitionKey, String processName, String bpmnProcessId) {
        }
        return this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, Result.class).stream().map(r -> Map.of("instanceId", r.id(), "processDefinitionId", r.processDefinitionKey(), "processDefinitionName", r.processName() != null ? r.processName() : r.bpmnProcessId())).toList();
    }

    @Override
    public long deleteDocument(String indexName, String idField, String id) throws IOException {
        return this.richOpenSearchClient.doc().delete(indexName, idField, id).deleted();
    }

    @Override
    public void deleteProcessInstanceFromTreePath(String processInstanceKey) {
        record Result(String id, String treePath) {
        }
        String treePath = this.getProcessInstanceTreePathById(processInstanceKey);
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate).query(QueryDSL.withTenantCheck(QueryDSL.and(QueryDSL.term("joinRelation", "processInstance"), QueryDSL.term("treePath", treePath), QueryDSL.not(QueryDSL.term("key", processInstanceKey))))).source(QueryDSL.sourceInclude("id", "treePath"));
        ArrayList results = new ArrayList();
        HashMap idToIndex = new HashMap();
        Consumer hitsConsumer = hits -> {
            for (Hit hit : hits) {
                results.add((Result)hit.source());
                idToIndex.put(hit.id(), hit.index());
            }
        };
        this.richOpenSearchClient.doc().scrollWith(searchRequestBuilder, Result.class, hitsConsumer);
        if (results.isEmpty()) {
            LOGGER.debug("No results in deleteProcessInstanceFromTreePath for process instance key {}", (Object)processInstanceKey);
            return;
        }
        BulkRequest.Builder bulk = new BulkRequest.Builder();
        results.forEach(r -> bulk.operations(op -> op.update(upd -> {
            String index = (String)idToIndex.get(r.id);
            String newTreePath = new TreePath(r.treePath()).removeProcessInstance(processInstanceKey).toString();
            record ProcessEntityUpdate(String treePath) {
            }
            return ((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(index)).id(r.id)).document((Object)new ProcessEntityUpdate(newTreePath)).retryOnConflict(Integer.valueOf(3));
        })));
        this.richOpenSearchClient.batch().bulk(bulk);
    }

    @Override
    public List<ProcessInstanceForListViewEntity> getProcessInstancesByProcessAndStates(long processDefinitionKey, Set<ProcessInstanceState> states, int size, String[] includeFields) {
        if (CollectionUtil.isEmpty(states)) {
            throw new OperateRuntimeException("Parameter 'states' is needed to search by states.");
        }
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder(this.listViewTemplate).size(Integer.valueOf(size)).query(QueryDSL.withTenantCheck(QueryDSL.and(QueryDSL.term("joinRelation", "processInstance"), QueryDSL.term("processDefinitionKey", processDefinitionKey), QueryDSL.stringTerms("state", states.stream().map(Enum::name).collect(Collectors.toList()))))).source(QueryDSL.sourceInclude(includeFields));
        return this.richOpenSearchClient.doc().searchValues(searchRequest, ProcessInstanceForListViewEntity.class);
    }

    @Override
    public List<ProcessInstanceForListViewEntity> getProcessInstancesByParentKeys(Set<Long> parentProcessInstanceKeys, int size, String[] includeFields) {
        if (CollectionUtil.isEmpty(parentProcessInstanceKeys)) {
            throw new OperateRuntimeException("Parameter 'parentProcessInstanceKeys' is needed to search by parents.");
        }
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder(this.listViewTemplate).query(QueryDSL.withTenantCheck(QueryDSL.and(QueryDSL.term("joinRelation", "processInstance"), QueryDSL.longTerms("parentProcessInstanceKey", parentProcessInstanceKeys)))).source(QueryDSL.sourceIncludesExcludes(includeFields, null));
        return this.richOpenSearchClient.doc().scrollValues(searchRequest, ProcessInstanceForListViewEntity.class);
    }

    @Override
    public long deleteProcessInstancesAndDependants(Set<Long> processInstanceKeys) {
        if (CollectionUtil.isEmpty(processInstanceKeys)) {
            return 0L;
        }
        long count = 0L;
        List<ProcessInstanceDependant> processInstanceDependantsWithoutOperation = this.processInstanceDependantTemplates.stream().filter(template -> !(template instanceof OperationTemplate)).toList();
        for (ProcessInstanceDependant template2 : processInstanceDependantsWithoutOperation) {
            String indexName = ((TemplateDescriptor)((Object)template2)).getAlias();
            count += this.richOpenSearchClient.doc().deleteByQuery(indexName, QueryDSL.longTerms("processInstanceKey", processInstanceKeys));
        }
        return count += this.richOpenSearchClient.doc().deleteByQuery(this.listViewTemplate.getAlias(), QueryDSL.longTerms("processInstanceKey", processInstanceKeys));
    }

    private Query withTenantIdQuery(@Nullable String tenantId, @Nullable Query query) {
        Query tenantIdQ;
        Query query2 = tenantIdQ = tenantId != null ? QueryDSL.term("tenantId", tenantId) : null;
        if (query != null || tenantId != null) {
            return QueryDSL.and(query, tenantIdQ);
        }
        return QueryDSL.matchAll();
    }
}

