/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.Metrics;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.meta.ImportPositionEntity;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.IndexMapping;
import io.camunda.operate.schema.indices.ImportPositionIndex;
import io.camunda.operate.store.ImportStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.Either;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.indices.PutMappingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchImportStore
implements ImportStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchImportStore.class);
    @Autowired
    private ImportPositionIndex importPositionType;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private Metrics metrics;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public ImportPositionEntity getImportPositionByAliasAndPartitionId(String alias, int partitionId) throws IOException {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.importPositionType.getAlias()).size(Integer.valueOf(10)).query(QueryDSL.and(QueryDSL.term("aliasName", alias), QueryDSL.term("partitionId", partitionId)));
        SearchResponse<ImportPositionEntity> response = this.richOpenSearchClient.doc().search(searchRequestBuilder, ImportPositionEntity.class);
        ImportPositionEntity importPositionEntity = new ImportPositionEntity();
        if (!response.hits().hits().isEmpty()) {
            importPositionEntity = (ImportPositionEntity)((Hit)response.hits().hits().get(0)).source();
        }
        LOGGER.debug("Latest loaded position for alias [{}] and partitionId [{}]: {}", new Object[]{alias, partitionId, importPositionEntity});
        importPositionEntity.setAliasName(alias).setPartitionId(partitionId);
        return importPositionEntity;
    }

    @Override
    public Either<Throwable, Boolean> updateImportPositions(List<ImportPositionEntity> positions, List<ImportPositionEntity> postImportPositions) {
        if (positions.isEmpty() && postImportPositions.isEmpty()) {
            return Either.right((Object)true);
        }
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        this.addPositions(bulkRequestBuilder, positions, ImportPositionUpdate::fromImportPositionEntity);
        this.addPositions(bulkRequestBuilder, postImportPositions, PostImportPositionUpdate::fromImportPositionEntity);
        try {
            this.withImportPositionTimer(() -> {
                this.richOpenSearchClient.batch().bulk(bulkRequestBuilder);
                return null;
            });
            return Either.right((Object)true);
        }
        catch (Throwable e) {
            LOGGER.error("Error occurred while persisting latest loaded position", e);
            return Either.left((Object)e);
        }
    }

    private void withImportPositionTimer(Callable<Void> action) throws Exception {
        this.metrics.getTimer("operate.import.position.update", new String[0]).recordCallable(action);
    }

    private <R> void addPositions(BulkRequest.Builder bulkRequestBuilder, List<ImportPositionEntity> positions, Function<ImportPositionEntity, R> entityProducer) {
        for (ImportPositionEntity position : positions) {
            bulkRequestBuilder.operations(op -> op.update(upd -> ((UpdateOperation.Builder)((UpdateOperation.Builder)upd.index(this.importPositionType.getFullQualifiedName())).id(position.getId())).upsert(entityProducer.apply(position)).document(entityProducer.apply(position))));
        }
    }

    @Override
    public void setConcurrencyMode(boolean concurrencyMode) {
        String indexName = this.importPositionType.getFullQualifiedName();
        LOGGER.debug("Meta field will be updated. Index name: {}. ");
        PutMappingRequest request = new PutMappingRequest.Builder().index(indexName, new String[0]).meta("concurrencyMode", JsonData.of((Object)concurrencyMode)).build();
        this.richOpenSearchClient.index().putMapping(request);
    }

    @Override
    public boolean getConcurrencyMode() {
        String indexName = this.importPositionType.getFullQualifiedName();
        Map<String, IndexMapping> indexMappings = this.richOpenSearchClient.index().getIndexMappings(indexName);
        if (indexMappings.get(indexName).getMetaProperties() == null) {
            return false;
        }
        Object concurrencyMode = indexMappings.get(indexName).getMetaProperties().get("concurrencyMode");
        return concurrencyMode != null && (Boolean)concurrencyMode != false;
    }

    record PostImportPositionUpdate(Long postImporterPosition) {
        public static PostImportPositionUpdate fromImportPositionEntity(ImportPositionEntity position) {
            return new PostImportPositionUpdate(position.getPostImporterPosition());
        }
    }

    record ImportPositionUpdate(String id, String aliasName, String indexName, int partitionId, long position, Long postImporterPosition, long sequence) {
        public static ImportPositionUpdate fromImportPositionEntity(ImportPositionEntity position) {
            return new ImportPositionUpdate(position.getId(), position.getAliasName(), position.getIndexName(), position.getPartitionId(), position.getPosition(), position.getPostImporterPosition(), position.getSequence());
        }
    }
}

