/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.FlowNodeStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.ThreadUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchFlowNodeStore
implements FlowNodeStore {
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private FlowNodeInstanceTemplate flowNodeInstanceTemplate;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public String getFlowNodeIdByFlowNodeInstanceId(String flowNodeInstanceId) {
        RequestDSL.QueryType queryType = this.operateProperties.getImporter().isReadArchivedParents() ? RequestDSL.QueryType.ALL : RequestDSL.QueryType.ONLY_RUNTIME;
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate, queryType).query(QueryDSL.withTenantCheck(QueryDSL.and(QueryDSL.term("joinRelation", "activity"), QueryDSL.term("id", flowNodeInstanceId))));
        record Result(String activityId) {
        }
        return this.richOpenSearchClient.doc().searchUnique(searchRequestBuilder, Result.class, flowNodeInstanceId).activityId();
    }

    @Override
    public Map<String, String> getFlowNodeIdsForFlowNodeInstances(Set<String> flowNodeInstanceIds) {
        record Result(String flowNodeId) {
        }
        HashMap<String, String> flowNodeIdsMap = new HashMap<String, String>();
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.flowNodeInstanceTemplate, RequestDSL.QueryType.ONLY_RUNTIME).query(QueryDSL.withTenantCheck(QueryDSL.stringTerms("id", flowNodeInstanceIds)));
        Consumer hitsConsumer = hits -> hits.forEach(h -> flowNodeIdsMap.put(h.id(), ((Result)h.source()).flowNodeId()));
        this.richOpenSearchClient.doc().scrollWith(searchRequestBuilder, Result.class, hitsConsumer);
        return flowNodeIdsMap;
    }

    @Override
    public String findParentTreePathFor(long parentFlowNodeInstanceKey) {
        return this.findParentTreePath(parentFlowNodeInstanceKey, 0);
    }

    private String findParentTreePath(long parentFlowNodeInstanceKey, int attemptCount) {
        RequestDSL.QueryType queryType = this.operateProperties.getImporter().isReadArchivedParents() ? RequestDSL.QueryType.ALL : RequestDSL.QueryType.ONLY_RUNTIME;
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.flowNodeInstanceTemplate, queryType).query(QueryDSL.withTenantCheck(QueryDSL.term("key", parentFlowNodeInstanceKey)));
        record Result(String treePath) {
        }
        List hits = this.richOpenSearchClient.doc().search(searchRequestBuilder, Result.class).hits().hits();
        if (hits.size() > 0) {
            return ((Result)((Hit)hits.get(0)).source()).treePath();
        }
        if (attemptCount < 1 && this.operateProperties.getImporter().isRetryReadingParents()) {
            ThreadUtil.sleepFor((long)2000L);
            return this.findParentTreePath(parentFlowNodeInstanceKey, attemptCount + 1);
        }
        return null;
    }
}

