/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.indices.DecisionIndex;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.DecisionStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.ExceptionHelper;
import java.io.IOException;
import java.util.Optional;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchDecisionStore
implements DecisionStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchDecisionStore.class);
    private static final String DISTINCT_FIELD_COUNTS = "distinctFieldCounts";
    @Autowired
    private DecisionIndex decisionIndex;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private BeanFactory beanFactory;

    @Override
    public Optional<Long> getDistinctCountFor(String fieldName) {
        String indexAlias = this.decisionIndex.getAlias();
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(indexAlias).query(QueryDSL.matchAll()).size(Integer.valueOf(0)).aggregations(DISTINCT_FIELD_COUNTS, AggregationDSL.cardinalityAggregation(fieldName, 1000)._toAggregation());
        try {
            SearchResponse<Void> searchResponse = this.richOpenSearchClient.doc().search(searchRequestBuilder, Void.class);
            return Optional.of(((Aggregate)searchResponse.aggregations().get(DISTINCT_FIELD_COUNTS)).cardinality().value());
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error in distinct count for field %s in index alias %s.", fieldName, indexAlias), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public BatchRequest newBatchRequest() {
        return (BatchRequest)this.beanFactory.getBean(BatchRequest.class);
    }

    @Override
    public long deleteDocuments(String indexName, String idField, String id) throws IOException {
        return ExceptionHelper.withIOException(() -> this.richOpenSearchClient.doc().delete(indexName, idField, id).deleted());
    }
}

