/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.IndexMapping;
import io.camunda.operate.schema.indices.IndexDescriptor;
import io.camunda.operate.store.elasticsearch.ElasticsearchTaskStore;
import io.camunda.operate.store.elasticsearch.dao.response.TaskResponse;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.Either;
import io.camunda.operate.util.RetryOperation;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indexlifecycle.PutLifecyclePolicyRequest;
import org.elasticsearch.client.indices.ComposableIndexTemplateExistRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.DeleteComposableIndexTemplateRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.PutComponentTemplateRequest;
import org.elasticsearch.client.indices.PutComposableIndexTemplateRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class RetryElasticsearchClient {
    public static final String REFRESH_INTERVAL = "index.refresh_interval";
    public static final String NO_REFRESH = "-1";
    public static final String NUMBERS_OF_REPLICA = "index.number_of_replicas";
    public static final String NO_REPLICA = "0";
    public static final int SCROLL_KEEP_ALIVE_MS = 60000;
    public static final int DEFAULT_NUMBER_OF_RETRIES = 300;
    public static final int DEFAULT_DELAY_INTERVAL_IN_SECONDS = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryElasticsearchClient.class);
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private ElasticsearchTaskStore elasticsearchTaskStore;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    private RequestOptions requestOptions = RequestOptions.DEFAULT;
    private int numberOfRetries = 300;
    private int delayIntervalInSeconds = 2;

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public RetryElasticsearchClient setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        return this;
    }

    public boolean isHealthy() {
        try {
            ClusterHealthResponse response = this.esClient.cluster().health(new ClusterHealthRequest().timeout(TimeValue.timeValueMillis((long)500L)), RequestOptions.DEFAULT);
            ClusterHealthStatus status = response.getStatus();
            return !response.isTimedOut() && !status.equals((Object)ClusterHealthStatus.RED);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Couldn't connect to Elasticsearch due to %s. Return unhealthy state. ", e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public int getDelayIntervalInSeconds() {
        return this.delayIntervalInSeconds;
    }

    public RetryElasticsearchClient setDelayIntervalInSeconds(int delayIntervalInSeconds) {
        this.delayIntervalInSeconds = delayIntervalInSeconds;
        return this;
    }

    public RetryElasticsearchClient setRequestOptions(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
        return this;
    }

    public void refresh(String indexPattern) {
        this.executeWithRetries("Refresh " + indexPattern, () -> {
            try {
                for (String index : this.getFilteredIndices(indexPattern)) {
                    this.esClient.indices().refresh(new RefreshRequest(new String[]{index}), this.requestOptions);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        });
    }

    private void refreshAndRetryOnShardFailures(String indexPattern) {
        this.executeWithRetries("Refresh " + indexPattern, () -> this.esClient.indices().refresh(new RefreshRequest(new String[]{indexPattern}), this.requestOptions), r -> r.getFailedShards() > 0);
    }

    public long getNumberOfDocumentsFor(String ... indexPatterns) {
        CountResponse response = (CountResponse)this.executeWithRetries("Count number of documents in " + String.valueOf(Arrays.asList(indexPatterns)), () -> this.esClient.count(new CountRequest(indexPatterns), this.requestOptions), c -> c.getFailedShards() > 0);
        return response.getCount();
    }

    public Set<String> getIndexNames(String namePattern) {
        return (Set)this.executeWithRetries("Get indices for " + namePattern, () -> {
            try {
                GetIndexResponse response = this.esClient.indices().get(new GetIndexRequest(new String[]{namePattern}), RequestOptions.DEFAULT);
                return Set.of(response.getIndices());
            }
            catch (ElasticsearchException e) {
                if (e.status().equals((Object)RestStatus.NOT_FOUND)) {
                    return Set.of();
                }
                throw e;
            }
        });
    }

    public Map<String, IndexMapping> getIndexMappings(String namePattern) {
        return (Map)this.executeWithRetries("Get indices mappings for " + namePattern, () -> {
            try {
                HashMap<String, IndexMapping> mappingsMap = new HashMap<String, IndexMapping>();
                Map mappings = this.esClient.indices().getMapping(new GetMappingsRequest().indices(new String[]{namePattern}), RequestOptions.DEFAULT).mappings();
                for (Map.Entry entry : mappings.entrySet()) {
                    Map mappingMetadata = (Map)this.objectMapper.readValue(((MappingMetadata)entry.getValue()).source().string(), (TypeReference)new TypeReference<HashMap<String, Object>>(this){});
                    Map properties = (Map)mappingMetadata.get("properties");
                    Map metaProperties = (Map)mappingMetadata.get("_meta");
                    String dynamic = (String)mappingMetadata.get("dynamic");
                    mappingsMap.put((String)entry.getKey(), new IndexMapping().setIndexName((String)entry.getKey()).setDynamic(dynamic).setProperties(properties.entrySet().stream().map(p -> IndexMapping.IndexMappingProperty.createIndexMappingProperty(p)).collect(Collectors.toSet())).setMetaProperties(metaProperties));
                }
                return mappingsMap;
            }
            catch (ElasticsearchException e) {
                if (e.status().equals((Object)RestStatus.NOT_FOUND)) {
                    return Map.of();
                }
                throw e;
            }
        });
    }

    public Set<String> getAliasesNames(String namePattern) {
        return (Set)this.executeWithRetries("Get aliases for " + namePattern, () -> {
            try {
                GetAliasesRequest request = new GetAliasesRequest(new String[]{namePattern});
                GetAliasesResponse response = this.esClient.indices().getAlias(request, this.requestOptions);
                HashSet returnAliases = new HashSet();
                Map mapAliases = response.getAliases();
                for (Map.Entry a : mapAliases.entrySet()) {
                    returnAliases.addAll(((Set)a.getValue()).stream().map(m -> m.getAlias()).collect(Collectors.toSet()));
                }
                return returnAliases;
            }
            catch (ElasticsearchException e) {
                if (e.status().equals((Object)RestStatus.NOT_FOUND)) {
                    return Set.of();
                }
                throw e;
            }
        });
    }

    public boolean createIndex(CreateIndexRequest createIndexRequest) {
        return (Boolean)this.executeWithRetries("CreateIndex " + createIndexRequest.index(), () -> {
            if (!this.indicesExist(createIndexRequest.index())) {
                return this.esClient.indices().create(createIndexRequest, this.requestOptions).isAcknowledged();
            }
            if (CollectionUtil.isNotEmpty((Collection)createIndexRequest.aliases()) && !this.aliasExists((Alias)createIndexRequest.aliases().iterator().next(), createIndexRequest.index())) {
                IndicesAliasesRequest request = new IndicesAliasesRequest();
                IndicesAliasesRequest.AliasActions aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(createIndexRequest.index()).alias(((Alias)createIndexRequest.aliases().iterator().next()).name()).writeIndex(Boolean.valueOf(false));
                request.addAliasAction(aliasAction);
                this.esClient.indices().updateAliases(request, RequestOptions.DEFAULT);
                LOGGER.info("Alias is created. Index: {}, alias: {} ", (Object)createIndexRequest.index(), (Object)((Alias)createIndexRequest.aliases().iterator().next()).name());
                return true;
            }
            return true;
        });
    }

    private boolean aliasExists(Alias alias, String index) throws IOException {
        GetAliasesRequest aliasExistsReq = new GetAliasesRequest(new String[]{alias.name()}).indices(new String[]{index});
        return this.esClient.indices().existsAlias(aliasExistsReq, RequestOptions.DEFAULT);
    }

    public boolean createOrUpdateDocument(String name, String id, Map source) {
        return (Boolean)this.executeWithRetries("RetryElasticsearchClient#createOrUpdateDocument", () -> {
            IndexResponse response = this.esClient.index(new IndexRequest(name).id(id).source(source, XContentType.JSON), this.requestOptions);
            DocWriteResponse.Result result = response.getResult();
            return result.equals((Object)DocWriteResponse.Result.CREATED) || result.equals((Object)DocWriteResponse.Result.UPDATED);
        });
    }

    public boolean createOrUpdateDocument(String name, String id, String source) {
        return (Boolean)this.executeWithRetries("RetryElasticsearchClient#createOrUpdateDocument", () -> {
            IndexResponse response = this.esClient.index(new IndexRequest(name).id(id).source(source, XContentType.JSON), this.requestOptions);
            DocWriteResponse.Result result = response.getResult();
            return result.equals((Object)DocWriteResponse.Result.CREATED) || result.equals((Object)DocWriteResponse.Result.UPDATED);
        });
    }

    public boolean documentExists(String name, String id) {
        return (Boolean)this.executeWithGivenRetries(10, String.format("Exists document from %s with id %s", name, id), () -> this.esClient.exists(new GetRequest(name).id(id), this.requestOptions), null);
    }

    public Map<String, Object> getDocument(String name, String id) {
        return (Map)this.executeWithGivenRetries(10, String.format("Get document from %s with id %s", name, id), () -> {
            GetRequest request = new GetRequest(name).id(id);
            GetResponse response = this.esClient.get(request, this.requestOptions);
            if (response.isExists()) {
                return response.getSourceAsMap();
            }
            return null;
        }, null);
    }

    public boolean deleteDocument(String name, String id) {
        return (Boolean)this.executeWithRetries("RetryElasticsearchClient#deleteDocument", () -> {
            DeleteResponse response = this.esClient.delete(new DeleteRequest(name).id(id), this.requestOptions);
            DocWriteResponse.Result result = response.getResult();
            return result.equals((Object)DocWriteResponse.Result.DELETED);
        });
    }

    private boolean templatesExist(String templatePattern) throws IOException {
        return this.esClient.indices().existsIndexTemplate(new ComposableIndexTemplateExistRequest(templatePattern), this.requestOptions);
    }

    public boolean createComponentTemplate(PutComponentTemplateRequest request) {
        return (Boolean)this.executeWithRetries("CreateComponentTemplate " + request.name(), () -> {
            if (!this.templatesExist(request.name())) {
                return this.esClient.cluster().putComponentTemplate(request, this.requestOptions).isAcknowledged();
            }
            return true;
        });
    }

    public boolean createTemplate(PutComposableIndexTemplateRequest request) {
        return this.createTemplate(request, false);
    }

    public boolean createTemplate(PutComposableIndexTemplateRequest request, boolean overwrite) {
        return (Boolean)this.executeWithRetries("CreateTemplate " + request.name(), () -> {
            if (overwrite || !this.templatesExist(request.name())) {
                return this.esClient.indices().putIndexTemplate(request, this.requestOptions).isAcknowledged();
            }
            return true;
        });
    }

    public boolean deleteTemplatesFor(String templateNamePattern) {
        return (Boolean)this.executeWithRetries("DeleteTemplate " + templateNamePattern, () -> {
            if (this.templatesExist(templateNamePattern)) {
                return this.esClient.indices().deleteIndexTemplate(new DeleteComposableIndexTemplateRequest(templateNamePattern), this.requestOptions).isAcknowledged();
            }
            return true;
        });
    }

    private boolean indicesExist(String indexPattern) throws IOException {
        return this.esClient.indices().exists(new GetIndexRequest(new String[]{indexPattern}).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)false, (boolean)true, (boolean)false)), this.requestOptions);
    }

    private Set<String> getFilteredIndices(String indexPattern) throws IOException {
        return ((Stream)Arrays.stream(this.esClient.indices().get(new GetIndexRequest(new String[]{indexPattern}), RequestOptions.DEFAULT).getIndices()).sequential()).collect(Collectors.toSet());
    }

    public boolean deleteIndicesFor(String indexPattern) {
        return (Boolean)this.executeWithRetries("DeleteIndices " + indexPattern, () -> {
            for (String index : this.getFilteredIndices(indexPattern)) {
                this.esClient.indices().delete(new DeleteIndexRequest(index), RequestOptions.DEFAULT);
            }
            return true;
        });
    }

    public Map<String, String> getIndexSettingsFor(String indexName, String ... fields) {
        return (Map)this.executeWithRetries("GetIndexSettings " + indexName, () -> {
            HashMap<String, String> settings = new HashMap<String, String>();
            GetSettingsResponse response = this.esClient.indices().getSettings(new GetSettingsRequest().indices(new String[]{indexName}), this.requestOptions);
            for (String field : fields) {
                settings.put(field, response.getSetting(indexName, field));
            }
            return settings;
        });
    }

    public String getOrDefaultRefreshInterval(String indexName, String defaultValue) {
        Map<String, String> settings = this.getIndexSettingsFor(indexName, REFRESH_INTERVAL);
        String refreshInterval = (String)CollectionUtil.getOrDefaultForNullValue(settings, (Object)REFRESH_INTERVAL, (Object)defaultValue);
        if (refreshInterval.trim().equals(NO_REFRESH)) {
            refreshInterval = defaultValue;
        }
        return refreshInterval;
    }

    public String getOrDefaultNumbersOfReplica(String indexName, String defaultValue) {
        Map<String, String> settings = this.getIndexSettingsFor(indexName, NUMBERS_OF_REPLICA);
        String numbersOfReplica = (String)CollectionUtil.getOrDefaultForNullValue(settings, (Object)NUMBERS_OF_REPLICA, (Object)defaultValue);
        if (numbersOfReplica.trim().equals(NO_REPLICA)) {
            numbersOfReplica = defaultValue;
        }
        return numbersOfReplica;
    }

    public boolean setIndexSettingsFor(Settings settings, String indexPattern) {
        return (Boolean)this.executeWithRetries("SetIndexSettings " + indexPattern, () -> this.esClient.indices().putSettings(new UpdateSettingsRequest(new String[]{indexPattern}).settings(settings), this.requestOptions).isAcknowledged());
    }

    public boolean addPipeline(String name, String definition) {
        BytesArray content = new BytesArray(definition.getBytes());
        return (Boolean)this.executeWithRetries("AddPipeline " + name, () -> this.lambda$addPipeline$22(name, (BytesReference)content));
    }

    public boolean removePipeline(String name) {
        return (Boolean)this.executeWithRetries("RemovePipeline " + name, () -> this.esClient.ingest().deletePipeline(new DeletePipelineRequest(name), this.requestOptions).isAcknowledged());
    }

    public void reindex(ReindexRequest reindexRequest) {
        this.reindex(reindexRequest, true);
    }

    public void reindex(ReindexRequest reindexRequest, boolean checkDocumentCount) {
        this.executeWithRetries("Reindex " + String.valueOf(Arrays.asList(reindexRequest.getSearchRequest().indices())) + " -> " + reindexRequest.getDestination().index(), () -> {
            String taskId;
            String srcIndices = reindexRequest.getSearchRequest().indices()[0];
            String dstIndex = reindexRequest.getDestination().indices()[0];
            long srcCount = this.getNumberOfDocumentsFor(srcIndices);
            List<String> taskIds = this.elasticsearchTaskStore.getRunningReindexTasksIdsFor(srcIndices, dstIndex);
            if (taskIds == null || taskIds.isEmpty()) {
                if (checkDocumentCount) {
                    this.refreshAndRetryOnShardFailures(dstIndex + "*");
                    long dstCount = this.getNumberOfDocumentsFor(dstIndex + "*");
                    if (srcCount == dstCount) {
                        LOGGER.info("Reindex of {} -> {} is already done.", (Object)srcIndices, (Object)dstIndex);
                        return true;
                    }
                }
                taskId = this.esClient.submitReindexTask(reindexRequest, this.requestOptions).getTask();
            } else {
                LOGGER.info("There is an already running reindex task for [{}] -> [{}]. Will not submit another reindex task but wait for completion of this task", (Object)srcIndices, (Object)dstIndex);
                taskId = taskIds.get(0);
            }
            TimeUnit.of(ChronoUnit.MILLIS).sleep(2000L);
            if (checkDocumentCount) {
                return this.waitUntilTaskIsCompleted(taskId, srcCount);
            }
            return this.waitUntilTaskIsCompleted(taskId);
        }, done -> done == false);
    }

    private boolean waitUntilTaskIsCompleted(String taskId) {
        return this.waitUntilTaskIsCompleted(taskId, null);
    }

    private boolean waitUntilTaskIsCompleted(String taskId, Long srcCount) {
        String[] taskIdParts = taskId.split(":");
        String nodeId = taskIdParts[0];
        Long smallTaskId = Long.parseLong(taskIdParts[1]);
        Optional maybeTaskResponse = (Optional)this.executeWithGivenRetries(Integer.MAX_VALUE, "GetTaskInfo{" + nodeId + "},{" + smallTaskId + "}", () -> {
            Either<IOException, TaskResponse> result = this.elasticsearchTaskStore.getTaskResponse(taskId);
            if (result.isLeft()) {
                IOException exception = (IOException)result.getLeft();
                String message = exception.getMessage();
                LOGGER.warn(String.format("Failed to retrieve TaskInfo {%s},{%d}: %s", nodeId, smallTaskId, message), (Throwable)exception);
                return Optional.empty();
            }
            TaskResponse taskResponse = (TaskResponse)result.get();
            this.elasticsearchTaskStore.checkForErrorsOrFailures(taskResponse);
            LOGGER.info("TaskId: {}, Progress: {}%", (Object)taskId, (Object)String.format("%.2f", taskResponse.getProgress() * 100.0));
            return Optional.of(taskResponse);
        }, this.elasticsearchTaskStore::needsToPollAgain);
        if (maybeTaskResponse.isPresent()) {
            long total = ((TaskResponse)maybeTaskResponse.get()).getTaskStatus().getTotal();
            if (srcCount != null) {
                LOGGER.info("Source docs: {}, Migrated docs: {}", (Object)srcCount, (Object)total);
                return total == srcCount;
            }
            LOGGER.info("Migrated docs: {}", (Object)total);
            return ((TaskResponse)maybeTaskResponse.get()).isCompleted();
        }
        return false;
    }

    public int doWithEachSearchResult(SearchRequest searchRequest, Consumer<SearchHit> searchHitConsumer) {
        return (Integer)this.executeWithRetries("RetryElasticsearchClient#doWithEachSearchResult", () -> {
            int doneOnSearchHits = 0;
            searchRequest.scroll(TimeValue.timeValueMillis((long)60000L));
            SearchResponse response = this.esClient.search(searchRequest, this.requestOptions);
            String scrollId = null;
            while (response.getHits().getHits().length > 0) {
                ((Stream)Arrays.stream(response.getHits().getHits()).sequential()).forEach(searchHitConsumer);
                doneOnSearchHits += response.getHits().getHits().length;
                scrollId = response.getScrollId();
                SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(TimeValue.timeValueMillis((long)60000L));
                response = this.esClient.scroll(scrollRequest, this.requestOptions);
            }
            if (scrollId != null) {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(scrollId);
                this.esClient.clearScroll(clearScrollRequest, this.requestOptions);
            }
            return doneOnSearchHits;
        });
    }

    public <T> List<T> searchWithScroll(SearchRequest searchRequest, Class<T> resultClass, ObjectMapper objectMapper) {
        long totalHits = (Long)this.executeWithRetries("Count search results", () -> this.esClient.search((SearchRequest)searchRequest, (RequestOptions)this.requestOptions).getHits().getTotalHits().value);
        return (List)this.executeWithRetries("Search with scroll", () -> this.scroll(searchRequest, resultClass, objectMapper), resultList -> (long)resultList.size() != totalHits);
    }

    private <T> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, ObjectMapper objectMapper) throws IOException {
        ArrayList results = new ArrayList();
        searchRequest.scroll(TimeValue.timeValueMillis((long)60000L));
        SearchResponse response = this.esClient.search(searchRequest, this.requestOptions);
        String scrollId = null;
        while (response.getHits().getHits().length > 0) {
            results.addAll(CollectionUtil.map((Object[])response.getHits().getHits(), searchHit -> this.searchHitToObject((SearchHit)searchHit, clazz, objectMapper)));
            scrollId = response.getScrollId();
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(TimeValue.timeValueMillis((long)60000L));
            response = this.esClient.scroll(scrollRequest, this.requestOptions);
        }
        if (scrollId != null) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(scrollId);
            this.esClient.clearScroll(clearScrollRequest, this.requestOptions);
        }
        return results;
    }

    private <T> T searchHitToObject(SearchHit searchHit, Class<T> clazz, ObjectMapper objectMapper) {
        try {
            return (T)objectMapper.readValue(searchHit.getSourceAsString(), clazz);
        }
        catch (JsonProcessingException e) {
            throw new OperateRuntimeException(String.format("Error while reading entity of type %s from Elasticsearch!", clazz.getName()), (Throwable)e);
        }
    }

    private <T> T executeWithRetries(String operationName, RetryOperation.RetryConsumer<T> retryConsumer) {
        return this.executeWithRetries(operationName, retryConsumer, null);
    }

    private <T> T executeWithRetries(String operationName, RetryOperation.RetryConsumer<T> retryConsumer, RetryOperation.RetryPredicate<T> retryPredicate) {
        return this.executeWithGivenRetries(this.numberOfRetries, operationName, retryConsumer, retryPredicate);
    }

    private <T> T executeWithGivenRetries(int retries, String operationName, RetryOperation.RetryConsumer<T> retryConsumer, RetryOperation.RetryPredicate<T> retryPredicate) {
        try {
            return (T)RetryOperation.newBuilder().retryConsumer(retryConsumer).retryPredicate(retryPredicate).noOfRetry(retries).delayInterval(this.delayIntervalInSeconds, TimeUnit.SECONDS).retryOn(new Class[]{IOException.class, ElasticsearchException.class}).retryPredicate(retryPredicate).message(operationName).build().retry();
        }
        catch (Exception e) {
            throw new OperateRuntimeException("Couldn't execute operation " + operationName + " on elasticsearch for " + this.numberOfRetries + " attempts with " + this.delayIntervalInSeconds + " seconds waiting.", (Throwable)e);
        }
    }

    public RestHighLevelClient getEsClient() {
        return this.esClient;
    }

    public boolean putLifeCyclePolicy(PutLifecyclePolicyRequest putLifecyclePolicyRequest) {
        return (Boolean)this.executeWithRetries(String.format("Put LifeCyclePolicy %s ", putLifecyclePolicyRequest.getName()), () -> this.esClient.indexLifecycle().putLifecyclePolicy(putLifecyclePolicyRequest, this.requestOptions).isAcknowledged(), null);
    }

    public void putMapping(PutMappingRequest request) {
        this.executeWithRetries(String.format("Put Mapping %s ", request.indices()), () -> this.esClient.indices().putMapping(request, RequestOptions.DEFAULT), null);
    }

    public void updateMetaField(IndexDescriptor indexDescriptor, String fieldName, Object value) {
        PutMappingRequest request;
        LOGGER.debug("Meta field will be updated. Index name: {}. ");
        try {
            request = new PutMappingRequest(new String[]{indexDescriptor.getFullQualifiedName()}).source("{\"_meta\": {\"" + fieldName + "\": " + this.objectMapper.writeValueAsString(value) + "}}", XContentType.JSON);
        }
        catch (JsonProcessingException e) {
            throw new OperateRuntimeException(String.format("Exception occurred when serializing meta field value for update. Field name: %s. Field value: %s.", fieldName, value));
        }
        this.putMapping(request);
    }

    private /* synthetic */ Boolean lambda$addPipeline$22(String name, BytesReference content) throws Exception {
        return this.esClient.ingest().putPipeline(new PutPipelineRequest(name, content, XContentType.JSON), this.requestOptions).isAcknowledged();
    }
}

