/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.MetricEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.indices.MetricIndex;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.MetricsStore;
import io.camunda.operate.store.elasticsearch.dao.Query;
import io.camunda.operate.store.elasticsearch.dao.UsageMetricDAO;
import io.camunda.operate.store.elasticsearch.dao.response.AggregationResponse;
import java.time.OffsetDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchMetricsStore
implements MetricsStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchMetricsStore.class);
    @Autowired
    private MetricIndex metricIndex;
    @Autowired
    private UsageMetricDAO dao;

    @Override
    public Long retrieveProcessInstanceCount(OffsetDateTime startTime, OffsetDateTime endTime) {
        boolean limit = true;
        Query query = Query.whereEquals("event", "EVENT_PROCESS_INSTANCE_FINISHED").or(Query.whereEquals("event", "EVENT_PROCESS_INSTANCE_STARTED")).and(Query.range("eventTime", startTime, endTime)).aggregate("process_instances", "value", 1);
        AggregationResponse response = this.dao.searchWithAggregation(query);
        if (response.hasError()) {
            String message = "Error while retrieving process instance count between dates";
            LOGGER.error("Error while retrieving process instance count between dates");
            throw new OperateRuntimeException("Error while retrieving process instance count between dates");
        }
        return response.getSumOfTotalDocs();
    }

    @Override
    public Long retrieveDecisionInstanceCount(OffsetDateTime startTime, OffsetDateTime endTime) {
        boolean limit = true;
        Query query = Query.whereEquals("event", "EVENT_DECISION_INSTANCE_EVALUATED").and(Query.range("eventTime", startTime, endTime)).aggregate("decision_instances", "value", 1);
        AggregationResponse response = this.dao.searchWithAggregation(query);
        if (response.hasError()) {
            String message = "Error while retrieving decision instance count between dates";
            LOGGER.error("Error while retrieving decision instance count between dates");
            throw new OperateRuntimeException("Error while retrieving decision instance count between dates");
        }
        return response.getSumOfTotalDocs();
    }

    @Override
    public void registerProcessInstanceStartEvent(String processInstanceKey, String tenantId, OffsetDateTime timestamp, BatchRequest batchRequest) throws PersistenceException {
        MetricEntity metric = this.createProcessInstanceStartedKey(processInstanceKey, tenantId, timestamp);
        batchRequest.add(this.metricIndex.getFullQualifiedName(), metric);
    }

    @Override
    public void registerDecisionInstanceCompleteEvent(String decisionInstanceKey, String tenantId, OffsetDateTime timestamp, BatchRequest batchRequest) throws PersistenceException {
        MetricEntity metric = this.createDecisionsInstanceEvaluatedKey(decisionInstanceKey, tenantId, timestamp);
        batchRequest.add(this.metricIndex.getFullQualifiedName(), metric);
    }

    private MetricEntity createProcessInstanceStartedKey(String processInstanceKey, String tenantId, OffsetDateTime timestamp) {
        return new MetricEntity().setEvent("EVENT_PROCESS_INSTANCE_STARTED").setValue(processInstanceKey).setEventTime(timestamp).setTenantId(tenantId);
    }

    private MetricEntity createDecisionsInstanceEvaluatedKey(String decisionInstanceKey, String tenantId, OffsetDateTime timestamp) {
        return new MetricEntity().setEvent("EVENT_DECISION_INSTANCE_EVALUATED").setValue(decisionInstanceKey).setEventTime(timestamp).setTenantId(tenantId);
    }
}

