/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.templates;

import io.camunda.operate.conditions.DatabaseInfo;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractTemplateDescriptor
implements TemplateDescriptor {
    private static final String SCHEMA_CREATE_TEMPLATE_JSON_ELASTICSEARCH = "/schema/elasticsearch/create/template/operate-%s.json";
    private static final String SCHEMA_CREATE_TEMPLATE_JSON_OPENSEARCH = "/schema/opensearch/create/template/operate-%s.json";
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public String getFullQualifiedName() {
        String indexPrefix = DatabaseInfo.isOpensearch() ? this.operateProperties.getOpensearch().getIndexPrefix() : this.operateProperties.getElasticsearch().getIndexPrefix();
        return String.format("%s-%s-%s_", indexPrefix, this.getIndexName(), this.getVersion());
    }

    @Override
    public String getSchemaClasspathFilename() {
        if (DatabaseInfo.isElasticsearch()) {
            return String.format(SCHEMA_CREATE_TEMPLATE_JSON_ELASTICSEARCH, this.getIndexName());
        }
        return String.format(SCHEMA_CREATE_TEMPLATE_JSON_OPENSEARCH, this.getIndexName());
    }

    @Override
    public String getAllVersionsIndexNameRegexPattern() {
        return String.format("%s-%s-\\d.*", this.operateProperties.getIndexPrefix(), this.getIndexName());
    }
}

